/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudApiClient;
import com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.impl.endpoint.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud.CloudWebhookConfiguration;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import java.util.Collection;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

public class BitbucketCloudEndpoint
extends AbstractBitbucketEndpoint {
    public static final String SERVER_URL = "https://bitbucket.org";
    private final boolean enableCache;
    private final int teamCacheDuration;
    private final int repositoriesCacheDuration;

    public BitbucketCloudEndpoint() {
        this(new CloudWebhookConfiguration(false, null, false, null));
    }

    @Restricted(value={NoExternalUse.class})
    public BitbucketCloudEndpoint(BitbucketWebhookConfiguration webhook) {
        this(false, 0, 0, webhook);
    }

    @DataBoundConstructor
    public BitbucketCloudEndpoint(boolean enableCache, int teamCacheDuration, int repositoriesCacheDuration, @NonNull BitbucketWebhookConfiguration webhook) {
        super(webhook);
        this.enableCache = enableCache;
        this.teamCacheDuration = teamCacheDuration;
        this.repositoriesCacheDuration = repositoriesCacheDuration;
    }

    public boolean isEnableCache() {
        return this.enableCache;
    }

    public int getTeamCacheDuration() {
        return this.teamCacheDuration;
    }

    public int getRepositoriesCacheDuration() {
        return this.repositoriesCacheDuration;
    }

    @Override
    public String getDisplayName() {
        return Messages.BitbucketCloudEndpoint_displayName();
    }

    @Override
    public String getServerURL() {
        return SERVER_URL;
    }

    @Override
    @NonNull
    public String getRepositoryURL(@NonNull String repoOwner, @NonNull String repository) {
        UriTemplate template = UriTemplate.fromTemplate((String)"https://bitbucket.org{/owner,repo}").set("owner", (Object)repoOwner).set("repo", (Object)repository);
        return template.expand();
    }

    @Override
    public EndpointType getType() {
        return EndpointType.CLOUD;
    }

    @Extension
    public static class DescriptorImpl
    extends BitbucketEndpointDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.BitbucketCloudEndpoint_displayName();
        }

        public FormValidation doShowStats() {
            Jenkins.get().checkPermission(Jenkins.MANAGE);
            List<String> stats = BitbucketCloudApiClient.stats();
            StringBuilder builder = new StringBuilder();
            for (String stat : stats) {
                builder.append(stat).append("<br>");
            }
            return FormValidation.okWithMarkup((String)builder.toString());
        }

        @POST
        public FormValidation doClear() {
            Jenkins.get().checkPermission(Jenkins.MANAGE);
            BitbucketCloudApiClient.clearCaches();
            return FormValidation.ok((String)"Caches cleared");
        }

        @RequirePOST
        public Collection<? extends Descriptor<?>> getWebhookDescriptors() {
            Jenkins.get().checkPermission(Jenkins.MANAGE);
            return ExtensionList.lookup(BitbucketWebhookDescriptor.class).stream().filter(webhook -> webhook.isApplicable(EndpointType.CLOUD)).toList();
        }
    }
}

