/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPushEvent;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudWebhookPayload;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.AbstractWebhookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud.CloudPushEvent;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.RestrictedSince;
import java.util.List;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import org.apache.commons.collections4.MultiValuedMap;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Extension
@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="933.3.0")
public class CloudPushWebhookProcessor
extends AbstractWebhookProcessor {
    private static final List<String> supportedEvents = List.of(HookEventType.PUSH.getKey());

    @Override
    public boolean canHandle(Map<String, String> headers, MultiValuedMap<String, String> parameters) {
        return headers.containsKey("X-Event-Key") && headers.containsKey("X-Request-UUID") && supportedEvents.contains(headers.get("X-Event-Key")) && !parameters.containsKey((Object)"server_url");
    }

    @Override
    @NonNull
    public String getServerURL(@NonNull Map<String, String> headers, @NonNull MultiValuedMap<String, String> parameters) {
        return "https://bitbucket.org";
    }

    @Override
    public void process(@NonNull String hookEventType, @NonNull String payload, @NonNull Map<String, Object> context, @NonNull BitbucketEndpoint endpoint) {
        BitbucketPushEvent push = BitbucketCloudWebhookPayload.pushEventFromPayload(payload);
        if (push != null) {
            if (push.getChanges().isEmpty()) {
                String owner = push.getRepository().getOwnerName();
                String repository = push.getRepository().getRepositoryName();
                this.scmSourceReIndex(owner, repository, null);
            } else {
                SCMEvent.Type type = null;
                for (BitbucketPushEvent.Change change : push.getChanges()) {
                    if ((type == null || type == SCMEvent.Type.CREATED) && change.isCreated()) {
                        type = SCMEvent.Type.CREATED;
                        continue;
                    }
                    if ((type == null || type == SCMEvent.Type.REMOVED) && change.isClosed()) {
                        type = SCMEvent.Type.REMOVED;
                        continue;
                    }
                    type = SCMEvent.Type.UPDATED;
                }
                this.notifyEvent(new CloudPushEvent(type, push, this.getOrigin(context)), BitbucketSCMSource.getEventDelaySeconds());
            }
        }
    }
}

