/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.api.webhook.BitbucketWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.AbstractBitbucketWebhookConfiguration;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.cloud.CloudWebhookManager;
import com.cloudbees.jenkins.plugins.bitbucket.util.BitbucketCredentialsUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class CloudWebhookConfiguration
extends AbstractBitbucketWebhookConfiguration {
    public CloudWebhookConfiguration(boolean manageHooks, String credentialsId) {
        this(manageHooks, credentialsId, false, null);
    }

    @DataBoundConstructor
    public CloudWebhookConfiguration(boolean manageHooks, String credentialsId, boolean enableHookSignature, String hookSignatureCredentialsId) {
        super(manageHooks, credentialsId, enableHookSignature, hookSignatureCredentialsId);
    }

    @Override
    public String getDisplayName() {
        return Messages.CloudWebhookImplementation_displayName();
    }

    @Override
    @NonNull
    public String getId() {
        return "CLOUD";
    }

    @Override
    public Class<? extends BitbucketWebhookManager> getManager() {
        return CloudWebhookManager.class;
    }

    @Symbol(value={"cloudWebhook"})
    @Extension
    public static class DescriptorImpl
    extends AbstractBitbucketWebhookConfiguration.AbstractBitbucketWebhookDescriptorImpl {
        @Override
        protected void clearCaches() {
            CloudWebhookManager.clearCaches();
        }

        @Override
        protected List<String> getStats() {
            return CloudWebhookManager.stats();
        }

        public String getDisplayName() {
            return "Native Cloud";
        }

        @Override
        public boolean isApplicable(EndpointType type) {
            return type == EndpointType.CLOUD;
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@QueryParameter(fixEmpty=true) String credentialsId) {
            Jenkins jenkins = DescriptorImpl.checkPermission();
            return BitbucketCredentialsUtils.listCredentials(jenkins, "https://bitbucket.org", credentialsId);
        }

        @RequirePOST
        public ListBoxModel doFillHookSignatureCredentialsIdItems(@QueryParameter(fixEmpty=true) String hookSignatureCredentialsId) {
            return super.getHookSignatureCredentialsIdItems(hookSignatureCredentialsId, "https://bitbucket.org");
        }
    }
}

