/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.impl.webhook.server;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMNavigator;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.scm.SCM;
import java.util.Collections;
import java.util.Map;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;

abstract class AbstractNativeServerSCMHeadEvent<P>
extends SCMHeadEvent<P> {
    @NonNull
    private final String serverURL;

    AbstractNativeServerSCMHeadEvent(String serverURL, SCMEvent.Type type, P payload, String origin) {
        super(type, payload, origin);
        this.serverURL = serverURL;
    }

    @NonNull
    public String getSourceName() {
        return this.getRepository().getRepositoryName();
    }

    public boolean isMatch(@NonNull SCMNavigator navigator) {
        if (!(navigator instanceof BitbucketSCMNavigator)) {
            return false;
        }
        BitbucketSCMNavigator bbNav = (BitbucketSCMNavigator)navigator;
        return this.isServerURLMatch(bbNav.getServerUrl()) && bbNav.getRepoOwner().equalsIgnoreCase(this.getRepository().getOwnerName());
    }

    public boolean isMatch(@NonNull SCM scm) {
        return false;
    }

    @NonNull
    public Map<SCMHead, SCMRevision> heads(@NonNull SCMSource source) {
        BitbucketSCMSource src = this.getMatchingBitbucketSource(source);
        return src == null ? Collections.emptyMap() : this.heads(src);
    }

    protected abstract BitbucketServerRepository getRepository();

    @NonNull
    protected abstract Map<SCMHead, SCMRevision> heads(@NonNull BitbucketSCMSource var1);

    protected boolean isServerURLMatch(String serverURL) {
        if (serverURL == null || BitbucketApiUtils.isCloud(serverURL)) {
            return false;
        }
        return serverURL.equals(this.serverURL);
    }

    protected boolean eventMatchesRepo(BitbucketSCMSource source) {
        BitbucketServerRepository repo = this.getRepository();
        return repo.getOwnerName().equalsIgnoreCase(source.getRepoOwner()) && repo.getRepositoryName().equalsIgnoreCase(source.getRepository());
    }

    protected BitbucketSCMSourceContext contextOf(BitbucketSCMSource source) {
        return (BitbucketSCMSourceContext)new BitbucketSCMSourceContext(null, (SCMHeadObserver)SCMHeadObserver.none()).withTraits(source.getTraits());
    }

    private BitbucketSCMSource getMatchingBitbucketSource(SCMSource source) {
        if (!(source instanceof BitbucketSCMSource)) {
            return null;
        }
        BitbucketSCMSource src = (BitbucketSCMSource)source;
        if (!this.isServerURLMatch(src.getServerUrl())) {
            return null;
        }
        return src;
    }
}

