/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.server.client.branch;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.DateUtils;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.branch.BitbucketServerAuthor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class BitbucketServerCommit
implements BitbucketCommit {
    private static final String GIT_COMMIT_AUTHOR = "{0} <{1}>";
    private String message;
    private String hash;
    private String author;
    private Date authorDate;
    private String committer;
    private Date committerDate;
    private List<String> parents;

    @JsonCreator
    public BitbucketServerCommit(@JsonProperty(value="message") @NonNull String message, @JsonProperty(value="id") @NonNull String hash, @JsonProperty(value="committer") @Nullable BitbucketServerAuthor committer, @JsonProperty(value="committerTimestamp") @NonNull long committerDateMillis, @JsonProperty(value="author") @Nullable BitbucketServerAuthor author, @JsonProperty(value="authorTimestamp") @NonNull long authorDateMillis, @JsonProperty(value="parents") @Nullable List<Parent> parents) {
        this(message, hash, committerDateMillis, author != null ? MessageFormat.format(GIT_COMMIT_AUTHOR, author.getName(), author.getEmail()) : null);
        if (committer != null) {
            this.committer = MessageFormat.format(GIT_COMMIT_AUTHOR, committer.getName(), committer.getEmail());
        }
        if (authorDateMillis > 0L) {
            this.authorDate = new Date(authorDateMillis);
        }
        if (parents != null) {
            this.parents = parents.stream().map(Parent::getHash).toList();
        }
    }

    public BitbucketServerCommit(String message, String hash, long dateMillis, String author) {
        this.message = message;
        this.hash = hash;
        this.committerDate = new Date(dateMillis);
        this.author = author;
    }

    public BitbucketServerCommit(String hash) {
        this.hash = hash;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    @Override
    @Deprecated(since="936.1.0", forRemoval=true)
    public String getDate() {
        return DateUtils.formatToISO(this.committerDate);
    }

    @Override
    @Deprecated(since="936.1.0", forRemoval=true)
    public long getDateMillis() {
        return this.committerDate != null ? this.committerDate.getTime() : 0L;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public Date getAuthorDate() {
        return this.authorDate;
    }

    public void setAuthorDate(Date authorDate) {
        this.authorDate = authorDate;
    }

    @Override
    public String getCommitter() {
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    @Override
    public Date getCommitterDate() {
        return this.committerDate;
    }

    public void setCommitter(Date committerDate) {
        this.committerDate = committerDate;
    }

    @Override
    public Collection<String> getParents() {
        return Collections.unmodifiableCollection(this.parents);
    }

    public static class Parent {
        private final String hash;

        @JsonCreator
        public Parent(@JsonProperty(value="id") @NonNull String hash) {
            this.hash = hash;
        }

        public String getHash() {
            return this.hash;
        }
    }
}

