/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.trait;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketGitSCMBuilder;
import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryProtocol;
import com.cloudbees.jenkins.plugins.bitbucket.trait.BitbucketSCMSourceTraitDescriptor;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.security.ACL;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import jenkins.model.Jenkins;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceTrait;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.springframework.security.core.Authentication;

public class SSHCheckoutTrait
extends SCMSourceTrait {
    @CheckForNull
    private final String credentialsId;

    @DataBoundConstructor
    public SSHCheckoutTrait(@CheckForNull String credentialsId) {
        this.credentialsId = "ANONYMOUS".equals(credentialsId) ? null : Util.fixEmpty((String)credentialsId);
    }

    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    protected void decorateBuilder(SCMBuilder<?, ?> builder) {
        if (builder instanceof BitbucketGitSCMBuilder) {
            BitbucketGitSCMBuilder gitBuilder = (BitbucketGitSCMBuilder)builder;
            gitBuilder.withCredentials(this.credentialsId, BitbucketRepositoryProtocol.SSH);
        }
    }

    @Symbol(value={"bitbucketSshCheckout"})
    @Extension
    public static class DescriptorImpl
    extends BitbucketSCMSourceTraitDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.SSHCheckoutTrait_displayName();
        }

        @Restricted(value={NoExternalUse.class})
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath @CheckForNull Item context, @QueryParameter String serverUrl, @QueryParameter String credentialsId) {
            Authentication authentication;
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(Item.EXTENDED_READ)) {
                return new StandardListBoxModel().includeCurrentValue(credentialsId);
            }
            StandardListBoxModel result = new StandardListBoxModel();
            result.add(Messages.SSHCheckoutTrait_useAgentKey(), "");
            if (context instanceof Queue.Task) {
                Queue.Task task = (Queue.Task)context;
                authentication = task.getDefaultAuthentication2();
            } else {
                authentication = ACL.SYSTEM2;
            }
            return result.includeMatchingAs(authentication, context, StandardUsernameCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), CredentialsMatchers.instanceOf(SSHUserPrivateKey.class));
        }

        @Restricted(value={NoExternalUse.class})
        public FormValidation doCheckCredentialsId(@AncestorInPath @CheckForNull Item context, @QueryParameter String serverUrl, @QueryParameter String value) {
            Authentication authentication;
            if (context == null ? !Jenkins.get().hasPermission(Jenkins.MANAGE) : !context.hasPermission(Item.EXTENDED_READ)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((CharSequence)value)) {
                return FormValidation.ok();
            }
            if (context instanceof Queue.Task) {
                Queue.Task task = (Queue.Task)context;
                v0 = task.getDefaultAuthentication2();
            } else {
                v0 = authentication = ACL.SYSTEM2;
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(SSHUserPrivateKey.class, (Item)context, (Authentication)authentication, (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)value)) != null) {
                return FormValidation.ok();
            }
            if (CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardUsernameCredentials.class, (Item)context, (Authentication)authentication, (List)URIRequirementBuilder.fromUri((String)serverUrl).build()), (CredentialsMatcher)CredentialsMatchers.withId((String)value)) != null) {
                return FormValidation.error((String)Messages.SSHCheckoutTrait_incompatibleCredentials());
            }
            return FormValidation.warning((String)Messages.SSHCheckoutTrait_missingCredentials());
        }
    }
}

