/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext;

import hudson.model.TaskListener;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import jakarta.mail.internet.InternetAddress;
import jenkins.model.Jenkins;

class RecipientListStringAnalyser {
    static final int NOT_FOUND = -1;
    private final TaskListener listener;
    private final ExtendedEmailPublisherDescriptor descriptor;
    private final String recipients;
    private int idx = 0;

    RecipientListStringAnalyser(String recipientsListString) {
        this(null, null, recipientsListString);
    }

    private RecipientListStringAnalyser(TaskListener listener, ExtendedEmailPublisherDescriptor descriptor, String recipientsListString) {
        this.listener = listener;
        this.descriptor = descriptor;
        this.recipients = recipientsListString;
        this.debug("Analyzing: %s", this.recipients);
    }

    static RecipientListStringAnalyser newInstance(TaskListener listener, String recipientsListString) {
        ExtendedEmailPublisherDescriptor descriptor = (ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class);
        return new RecipientListStringAnalyser(listener, descriptor, recipientsListString);
    }

    int getType(InternetAddress address) {
        int type = -1;
        this.debug("Looking for: %s", address);
        this.debug("\tstarting at: %d", this.idx);
        int firstFoundIdx = this.findFirst(address);
        this.debug("\tfirstFoundIdx: %d", firstFoundIdx);
        if (firstFoundIdx != Integer.MAX_VALUE) {
            this.debug("\tfirstFoundIdx-substring: %s", this.recipients.substring(firstFoundIdx));
            type = this.getType(firstFoundIdx);
            this.debug("\t=> found type: %d", type);
            this.idx = firstFoundIdx + this.lengthOfTypePrefix(type) + address.toString().length() + this.adaptLengthForOptionalPersonal(address) + 1;
        } else {
            this.debug("\t=> type not found", new Object[0]);
        }
        return type;
    }

    private int findFirst(InternetAddress address) {
        int firstIdx = Integer.MAX_VALUE;
        if (address.getPersonal() != null) {
            firstIdx = this.findFirst(firstIdx, "bcc:" + address.getPersonal());
            firstIdx = this.findFirst(firstIdx, "bcc:\"" + String.valueOf(address) + "\"");
            firstIdx = this.findFirst(firstIdx, "cc:" + address.getPersonal());
            firstIdx = this.findFirst(firstIdx, "cc:\"" + String.valueOf(address) + "\"");
            firstIdx = this.findFirst(firstIdx, address.getPersonal());
            firstIdx = this.findFirst(firstIdx, "\"" + String.valueOf(address) + "\"");
        } else {
            firstIdx = this.findFirst(firstIdx, "bcc:" + String.valueOf(address));
            firstIdx = this.findFirst(firstIdx, "cc:" + String.valueOf(address));
            firstIdx = this.findFirst(firstIdx, address.toString());
        }
        return firstIdx;
    }

    private int findFirst(int firstIdx, String search) {
        int foundIdx = this.recipients.indexOf(search, this.idx);
        return foundIdx == -1 ? firstIdx : Math.min(firstIdx, foundIdx);
    }

    private int getType(int firstFoundIdx) {
        int type = this.recipients.indexOf("bcc:", firstFoundIdx) == firstFoundIdx ? 2 : (this.recipients.indexOf("cc:", firstFoundIdx) == firstFoundIdx ? 1 : 0);
        return type;
    }

    private int lengthOfTypePrefix(int type) {
        return switch (type) {
            case 2 -> 4;
            case 1 -> 3;
            case 0 -> 0;
            default -> throw new IllegalArgumentException("Unknown type prefix: " + type);
        };
    }

    private int adaptLengthForOptionalPersonal(InternetAddress address) {
        return address.getPersonal() != null ? -4 : 0;
    }

    private void debug(String format, Object ... args) {
        if (this.descriptor != null && this.listener != null) {
            this.descriptor.debug(this.listener.getLogger(), format, args);
        }
    }
}

