/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.groovy.sandbox;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import groovy.lang.Binding;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.GroovyShell;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import groovy.lang.Writable;
import groovy.text.Template;
import groovy.text.TemplateEngine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.util.SystemProperties;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;

public class SimpleTemplateEngine
extends TemplateEngine {
    private static final Logger LOGGER = Logger.getLogger(SimpleTemplateEngine.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="non final to make it editable from the script console (convenient to temporarily change the value without restarting)")
    public static int MAX_EXPANDED_SIZE_BYTES = SystemProperties.getInteger((String)(SimpleTemplateEngine.class.getName() + ".MAX_EXPANDED_SIZE_BYTES"), (Integer)0x100000);
    private static AtomicInteger counter = new AtomicInteger(1);
    protected final GroovyShell groovyShell;
    private final boolean sandbox;

    public SimpleTemplateEngine(GroovyShell groovyShell, boolean sandbox) {
        this.groovyShell = groovyShell;
        this.sandbox = sandbox;
    }

    public Template createTemplate(Reader reader) throws CompilationFailedException, IOException {
        return this.createTemplate(reader, "SimpleTemplateScript" + counter.getAndIncrement() + ".groovy");
    }

    public Template createTemplate(Reader reader, String fileName) throws CompilationFailedException, IOException {
        SimpleTemplate template = new SimpleTemplate(this.sandbox);
        template.script = this.parseScript(reader, fileName);
        return template;
    }

    protected Script parseScript(Reader reader, String fileName) throws CompilationFailedException, IOException {
        Script script;
        block9: {
            String script2 = this.parse(reader);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("\n-- script source --");
                LOGGER.fine(script2);
                LOGGER.fine("\n-- script end --\n");
            }
            GroovySandbox.Scope scope = new GroovySandbox().enter();
            try {
                script = this.groovyShell.parse(script2, fileName);
                if (scope == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (scope != null) {
                        try {
                            scope.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new GroovyRuntimeException("Failed to parse template script (your template may contain an error or be trying to use expressions not currently supported): " + String.valueOf(e), (Throwable)e);
                }
            }
            scope.close();
        }
        return script;
    }

    protected String parse(Reader reader) throws IOException {
        int c;
        if (!reader.markSupported()) {
            reader = new BufferedReader(reader);
        }
        StringWriter sw = new StringWriter();
        this.startScript(sw);
        while ((c = reader.read()) != -1) {
            if (c == 60) {
                reader.mark(1);
                c = reader.read();
                if (c != 37) {
                    sw.write(60);
                    reader.reset();
                    continue;
                }
                reader.mark(1);
                c = reader.read();
                if (c == 61) {
                    this.groovyExpression(reader, sw);
                    continue;
                }
                reader.reset();
                this.groovySection(reader, sw);
                continue;
            }
            if (c == 36) {
                reader.mark(1);
                c = reader.read();
                if (c != 123) {
                    sw.write(36);
                    reader.reset();
                    continue;
                }
                reader.mark(1);
                sw.write("${");
                this.processGSstring(reader, sw);
                continue;
            }
            if (c == 34) {
                sw.write(92);
            }
            if (c == 10 || c == 13) {
                if (c == 13) {
                    reader.mark(1);
                    c = reader.read();
                    if (c != 10) {
                        reader.reset();
                    }
                }
                sw.write("\n");
                continue;
            }
            sw.write(c);
        }
        this.endScript(sw);
        return sw.toString();
    }

    private void startScript(StringWriter sw) {
        sw.write("/* Generated by SimpleTemplateEngine */\n");
        sw.write(this.printMethod() + "\"\"\"");
    }

    private void endScript(StringWriter sw) {
        sw.write("\"\"\");\n");
    }

    private void processGSstring(Reader reader, StringWriter sw) throws IOException {
        int c;
        while ((c = reader.read()) != -1) {
            if (c != 10 && c != 13) {
                sw.write(c);
            }
            if (c != 125) continue;
            break;
        }
    }

    private void groovyExpression(Reader reader, StringWriter sw) throws IOException {
        int c;
        sw.write("${");
        while ((c = reader.read()) != -1) {
            if (c == 37) {
                c = reader.read();
                if (c == 62) break;
                sw.write(37);
            }
            if (c == 10 || c == 13) continue;
            sw.write(c);
        }
        sw.write("}");
    }

    private void groovySection(Reader reader, StringWriter sw) throws IOException {
        int c;
        sw.write("\"\"\");");
        while ((c = reader.read()) != -1) {
            if (c == 37) {
                c = reader.read();
                if (c == 62) break;
                sw.write(37);
            }
            sw.write(c);
        }
        sw.write(";\n" + this.printMethod() + "\"\"\"");
    }

    protected String printMethod() {
        return "out.print(";
    }

    private static class SimpleTemplate
    implements Template {
        private final boolean sandbox;
        protected Script script;

        SimpleTemplate(boolean sandbox) {
            this.sandbox = sandbox;
        }

        public Writable make() {
            return this.make(null);
        }

        public Writable make(final Map map) {
            return new Writable(){

                public Writer writeTo(Writer writer) throws IOException {
                    PrintWriter pw;
                    block9: {
                        Binding binding = map == null ? new Binding() : new Binding(map);
                        pw = new PrintWriter(writer);
                        try {
                            if (sandbox) {
                                try (GroovySandbox.Scope scope = new GroovySandbox().enter();){
                                    Script scriptObject = InvokerHelper.createScript(script.getClass(), (Binding)binding);
                                    scriptObject.setProperty("out", (Object)pw);
                                    scriptObject.run();
                                    break block9;
                                }
                            }
                            Script scriptObject = InvokerHelper.createScript(script.getClass(), (Binding)binding);
                            scriptObject.setProperty("out", (Object)pw);
                            scriptObject.run();
                        }
                        catch (MissingPropertyException x) {
                            throw (IOException)new IOException("did you forget to escape \\$" + x.getProperty() + " for non-Groovy variables?").initCause(x);
                        }
                    }
                    pw.flush();
                    return writer;
                }

                public String toString() {
                    StringWriter sw = new StringWriter();
                    try {
                        this.writeTo(sw);
                    }
                    catch (IOException x) {
                        PrintWriter pw = new PrintWriter(sw);
                        x.printStackTrace(pw);
                        pw.flush();
                    }
                    return sw.toString();
                }
            };
        }
    }
}

