/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinjectapi.util;

import com.google.common.base.Joiner;
import hudson.model.Cause;
import hudson.triggers.SCMTrigger;
import hudson.triggers.TimerTrigger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;

class CauseHelper {
    private static final int MAX_UPSTREAM_DEPTH = 10;
    public static final String ENV_CAUSE = "BUILD_CAUSE";
    public static final String ENV_ROOT_CAUSE = "ROOT_BUILD_CAUSE";

    CauseHelper() {
    }

    static void insertRootCauseNames(@Nonnull Set<String> causeNamesTarget, @CheckForNull Cause cause, int depth) {
        if (cause instanceof Cause.UpstreamCause) {
            if (depth == 10) {
                causeNamesTarget.add("DEEPLYNESTEDCAUSES");
            } else {
                Cause.UpstreamCause c = (Cause.UpstreamCause)cause;
                List upstreamCauses = c.getUpstreamCauses();
                for (Cause upstreamCause : upstreamCauses) {
                    CauseHelper.insertRootCauseNames(causeNamesTarget, upstreamCause, depth + 1);
                }
            }
        } else {
            causeNamesTarget.add(CauseHelper.getTriggerName(cause));
        }
    }

    @Nonnull
    static Map<String, String> buildCauseEnvironmentVariables(@Nonnull String envBase, @Nonnull Collection<String> causeNames) {
        HashMap<String, String> triggerVars = new HashMap<String, String>();
        ArrayList<String> nonEmptyNames = new ArrayList<String>();
        for (String name : causeNames) {
            if (!StringUtils.isNotBlank((String)name)) continue;
            triggerVars.put(Joiner.on((String)"_").join((Object)envBase, (Object)name, new Object[0]), "true");
            nonEmptyNames.add(name);
        }
        triggerVars.put(envBase, Joiner.on((String)",").join(nonEmptyNames));
        return triggerVars;
    }

    @CheckForNull
    static String getTriggerName(Cause cause) {
        if (SCMTrigger.SCMTriggerCause.class.isInstance(cause)) {
            return "SCMTRIGGER";
        }
        if (TimerTrigger.TimerTriggerCause.class.isInstance(cause)) {
            return "TIMERTRIGGER";
        }
        if (Cause.UserIdCause.class.isInstance(cause)) {
            return "MANUALTRIGGER";
        }
        if (Cause.UserCause.class.isInstance(cause)) {
            return "MANUALTRIGGER";
        }
        if (Cause.UpstreamCause.class.isInstance(cause)) {
            return "UPSTREAMTRIGGER";
        }
        if (cause != null) {
            return cause.getClass().getSimpleName().toUpperCase(Locale.ENGLISH);
        }
        return null;
    }
}

