/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinjectapi.util;

import hudson.EnvVars;
import hudson.FilePath;
import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Computer;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.remoting.Callable;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.util.DescribableList;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinjectapi.util.CauseHelper;
import org.jenkinsci.plugins.envinjectapi.util.EnvInjectActionRetriever;
import org.jenkinsci.plugins.envinjectapi.util.EnvInjectPluginHelper;

public class EnvVarsResolver {
    private EnvVarsResolver() {
    }

    @Nonnull
    public static Map<String, String> getPollingEnvVars(@Nonnull Job<?, ?> job, @CheckForNull Node node) throws EnvInjectException {
        Run lastBuild = job.getLastBuild();
        if (lastBuild != null && EnvInjectPluginHelper.isEnvInjectPluginInstalled()) {
            return EnvVarsResolver.getEnVars(lastBuild);
        }
        if (node == null) {
            return EnvVarsResolver.getFallBackMasterNode(job);
        }
        if (node.getRootPath() == null) {
            return EnvVarsResolver.getFallBackMasterNode(job);
        }
        return EnvVarsResolver.getDefaultEnvVarsJob(job, node);
    }

    @Nonnull
    public static Map<String, String> getEnVars(@Nonnull Run<?, ?> run) throws EnvInjectException {
        Node builtOn;
        Action envInjectAction = EnvInjectActionRetriever.getEnvInjectAction(run);
        if (envInjectAction != null) {
            try {
                Method method = envInjectAction.getClass().getMethod("getEnvMap", new Class[0]);
                return (Map)method.invoke((Object)envInjectAction, new Object[0]);
            }
            catch (ClassCastException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new EnvInjectException((Throwable)e);
            }
        }
        Node node = builtOn = run instanceof AbstractBuild ? ((AbstractBuild)run).getBuiltOn() : null;
        if (builtOn == null) {
            return EnvVarsResolver.getFallBackMasterNode(run.getParent());
        }
        if (builtOn.getRootPath() == null) {
            return EnvVarsResolver.getFallBackMasterNode(run.getParent());
        }
        return EnvVarsResolver.getDefaultEnvVarsJob(run.getParent(), builtOn);
    }

    @Nonnull
    private static Map<String, String> getFallBackMasterNode(@Nonnull Job<?, ?> job) throws EnvInjectException {
        Node masterNode = EnvVarsResolver.getMasterNode();
        if (masterNode == null) {
            return EnvVarsResolver.gatherEnvVarsMaster(job);
        }
        return EnvVarsResolver.getDefaultEnvVarsJob(job, masterNode);
    }

    @CheckForNull
    private static Node getMasterNode() {
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return null;
        }
        Computer computer = jenkins.toComputer();
        if (computer == null) {
            return null;
        }
        return computer.getNode();
    }

    @CheckForNull
    public static String resolveEnvVars(@Nonnull Run<?, ?> run, @CheckForNull String value) throws EnvInjectException {
        if (value == null) {
            return null;
        }
        return Util.replaceMacro((String)value, EnvVarsResolver.getEnVars(run));
    }

    @Nonnull
    private static Map<String, String> getDefaultEnvVarsJob(@Nonnull Job<?, ?> job, @Nonnull Node node) throws EnvInjectException {
        assert (node.getRootPath() != null);
        Map<String, String> result = EnvVarsResolver.gatherEnvVarsMaster(job);
        result.putAll(EnvVarsResolver.gatherEnvVarsNode(job, node));
        result.putAll(EnvVarsResolver.gatherEnvVarsNodeProperties(node));
        return result;
    }

    @Nonnull
    private static Map<String, String> gatherEnvVarsMaster(@Nonnull Job<?, ?> job) throws EnvInjectException {
        Jenkins jenkins;
        try {
            jenkins = Jenkins.getActiveInstance();
        }
        catch (IllegalStateException ex) {
            throw new EnvInjectException((Throwable)ex);
        }
        EnvVars env = new EnvVars();
        env.put("JENKINS_SERVER_COOKIE", Util.getDigestOf((String)("ServerID:" + jenkins.getSecretKey())));
        env.put("HUDSON_SERVER_COOKIE", Util.getDigestOf((String)("ServerID:" + jenkins.getSecretKey())));
        env.put("JOB_NAME", job.getFullName());
        env.put("JENKINS_HOME", jenkins.getRootDir().getPath());
        env.put("HUDSON_HOME", jenkins.getRootDir().getPath());
        String rootUrl = jenkins.getRootUrl();
        if (rootUrl != null) {
            env.put("JENKINS_URL", rootUrl);
            env.put("HUDSON_URL", rootUrl);
            env.put("JOB_URL", rootUrl + job.getUrl());
        }
        return env;
    }

    @Nonnull
    private static Map<String, String> gatherEnvVarsNodeProperties(@CheckForNull Node node) throws EnvInjectException {
        DescribableList globalNodeProperties;
        EnvVars env = new EnvVars();
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins != null && (globalNodeProperties = jenkins.getGlobalNodeProperties()) != null) {
            for (NodeProperty nodeProperty : globalNodeProperties) {
                if (nodeProperty == null || !(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
                env.putAll((Map)((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars());
            }
        }
        if (node != null) {
            DescribableList nodeProperties = node.getNodeProperties();
            for (NodeProperty nodeProperty : nodeProperties) {
                EnvVars envVars;
                if (nodeProperty == null || !(nodeProperty instanceof EnvironmentVariablesNodeProperty) || (envVars = ((EnvironmentVariablesNodeProperty)nodeProperty).getEnvVars()) == null) continue;
                for (Map.Entry entry : envVars.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    if (key == null || value == null) continue;
                    env.put(key, value);
                }
            }
        }
        return env;
    }

    @Nonnull
    private static Map<String, String> gatherEnvVarsNode(@Nonnull Job<?, ?> job, @Nonnull Node node) throws EnvInjectException {
        FilePath rootPath = node.getRootPath();
        if (rootPath == null) {
            throw new EnvInjectException("Cannot retrieve Environment variables from the offline node");
        }
        try {
            FilePath wFilePath;
            EnvVars envVars = new EnvVars((Map)rootPath.act((Callable)new MasterToSlaveCallable<Map<String, String>, EnvInjectException>(){
                private static final long serialVersionUID = 1L;

                public Map<String, String> call() throws EnvInjectException {
                    return EnvVars.masterEnvVars;
                }
            }));
            envVars.put("NODE_NAME", node.getNodeName());
            envVars.put("NODE_LABELS", Util.join((Collection)node.getAssignedLabels(), (String)" "));
            if (job instanceof AbstractProject && (wFilePath = ((AbstractProject)job).getSomeWorkspace()) != null) {
                envVars.put("WORKSPACE", wFilePath.getRemote());
            }
            return envVars;
        }
        catch (IOException | InterruptedException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
    }

    @Nonnull
    public static Map<String, String> getCauseEnvVars(@Nonnull Run<?, ?> run) {
        CauseAction causeAction = (CauseAction)run.getAction(CauseAction.class);
        HashMap<String, String> env = new HashMap<String, String>();
        ArrayList<String> directCauseNames = new ArrayList<String>();
        LinkedHashSet<String> rootCauseNames = new LinkedHashSet<String>();
        if (causeAction != null) {
            List buildCauses = causeAction.getCauses();
            for (Cause cause : buildCauses) {
                directCauseNames.add(CauseHelper.getTriggerName(cause));
                CauseHelper.insertRootCauseNames(rootCauseNames, cause, 0);
            }
        } else {
            directCauseNames.add("UNKNOWN");
            rootCauseNames.add("UNKNOWN");
        }
        env.putAll(CauseHelper.buildCauseEnvironmentVariables("BUILD_CAUSE", directCauseNames));
        env.putAll(CauseHelper.buildCauseEnvironmentVariables("ROOT_BUILD_CAUSE", rootCauseNames));
        return env;
    }
}

