/*
 * Decompiled with CFR 0.152.
 */
package com.google.jenkins.flakyTestHandler.junit;

import com.google.jenkins.flakyTestHandler.junit.ActionableFlakyTestObject;
import com.google.jenkins.flakyTestHandler.junit.FlakyCaseResult;
import com.google.jenkins.flakyTestHandler.junit.FlakyPackageResult;
import com.google.jenkins.flakyTestHandler.plugin.JUnitFlakyAggregatedTestDataAction;
import hudson.model.AbstractBuild;
import hudson.tasks.junit.Messages;
import hudson.tasks.junit.TestAction;
import hudson.tasks.junit.TestNameTransformer;
import hudson.tasks.test.TabulatedResult;
import hudson.tasks.test.TestObject;
import hudson.tasks.test.TestResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.kohsuke.accmod.restrictions.suppressions.SuppressRestrictedWarnings;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public final class FlakyClassResult
extends TabulatedResult
implements Comparable<FlakyClassResult>,
ActionableFlakyTestObject {
    private static final long serialVersionUID = 1L;
    private final String className;
    private transient String safeName;
    private final List<FlakyCaseResult> cases = new ArrayList<FlakyCaseResult>();
    private int passCount;
    private int failCount;
    private int skipCount;
    private int flakeCount;
    private float duration;
    private final FlakyPackageResult parent;

    FlakyClassResult(FlakyPackageResult parent, String className) {
        this.parent = parent;
        this.className = className;
    }

    public AbstractBuild<?, ?> getOwner() {
        return this.parent == null ? null : this.parent.getOwner();
    }

    public FlakyPackageResult getParent() {
        return this.parent;
    }

    public FlakyClassResult getPreviousResult() {
        if (this.parent == null) {
            return null;
        }
        TestResult pr = this.parent.getPreviousResult();
        if (pr == null) {
            return null;
        }
        if (pr instanceof FlakyPackageResult) {
            return ((FlakyPackageResult)pr).getClassResult(this.getName());
        }
        return null;
    }

    public TestResult findCorrespondingResult(String id) {
        FlakyCaseResult child;
        String myID = FlakyClassResult.safe((String)this.getName());
        String caseName = id;
        int base = id.indexOf(myID);
        if (base > 0) {
            int caseNameStart = base + myID.length() + 1;
            if (id.length() > caseNameStart) {
                caseName = id.substring(caseNameStart);
            }
        }
        if ((child = this.getCaseResult(caseName)) != null) {
            return child;
        }
        return null;
    }

    @SuppressRestrictedWarnings(value={Messages.class})
    public String getTitle() {
        return Messages.ClassResult_getTitle((Object)this.getDisplayName());
    }

    public String getChildTitle() {
        return "Class Reults";
    }

    @Exported(visibility=999)
    public String getName() {
        int idx = this.className.lastIndexOf(46);
        if (idx < 0) {
            return this.className;
        }
        return this.className.substring(idx + 1);
    }

    public synchronized String getSafeName() {
        if (this.safeName != null) {
            return this.safeName;
        }
        this.safeName = FlakyClassResult.safe((String)this.getName());
        return this.safeName;
    }

    public FlakyCaseResult getCaseResult(String name) {
        for (FlakyCaseResult c : this.cases) {
            if (!c.getSafeName().equals(name)) continue;
            return c;
        }
        return null;
    }

    public Object getDynamic(String name, StaplerRequest req, StaplerResponse rsp) {
        FlakyCaseResult c = this.getCaseResult(name);
        if (c != null) {
            return c;
        }
        return super.getDynamic(name, req, rsp);
    }

    @Exported(name="child")
    public List<FlakyCaseResult> getChildren() {
        return this.cases;
    }

    public boolean hasChildren() {
        return this.cases != null && this.cases.size() > 0;
    }

    @Exported
    public float getDuration() {
        return this.duration;
    }

    @Exported
    public int getPassCount() {
        return this.passCount;
    }

    @Exported
    public int getFailCount() {
        return this.failCount;
    }

    @Exported
    public int getSkipCount() {
        return this.skipCount;
    }

    @Exported
    public int getFlakeCount() {
        return this.flakeCount;
    }

    public void add(FlakyCaseResult r) {
        this.cases.add(r);
    }

    public void tally() {
        this.flakeCount = 0;
        this.skipCount = 0;
        this.failCount = 0;
        this.passCount = 0;
        this.duration = 0.0f;
        for (FlakyCaseResult r : this.cases) {
            r.setClass(this);
            if (r.isSkipped()) {
                ++this.skipCount;
            } else if (r.isFlaked()) {
                ++this.flakeCount;
            } else if (r.isPassed()) {
                ++this.passCount;
            } else {
                ++this.failCount;
            }
            this.duration += r.getDuration();
        }
    }

    void freeze() {
        this.tally();
        Collections.sort(this.cases);
    }

    public String getClassName() {
        return this.className;
    }

    @Override
    public int compareTo(FlakyClassResult that) {
        return this.className.compareTo(that.className);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlakyClassResult that = (FlakyClassResult)o;
        return Objects.equals(this.className, that.className);
    }

    public int hashCode() {
        return Objects.hash(this.className);
    }

    public String getDisplayName() {
        return TestNameTransformer.getTransformedName((String)this.getName());
    }

    public String getFullName() {
        return this.getParent().getName() + "." + this.className;
    }

    public String getFullDisplayName() {
        return this.getParent().getDisplayName() + "." + TestNameTransformer.getTransformedName((String)this.className);
    }

    public String getRelativePathFrom(TestObject it) {
        if (it instanceof FlakyCaseResult) {
            return "..";
        }
        return super.getRelativePathFrom(it);
    }

    @Override
    public TestAction getTestAction() {
        return new JUnitFlakyAggregatedTestDataAction(this.getPassCount(), this.getFailCount(), this.getFlakeCount());
    }
}

