/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gwt.jobfinder;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Item;
import hudson.model.Saveable;
import hudson.model.listeners.ItemListener;
import hudson.model.listeners.SaveableListener;
import hudson.security.ACL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import jenkins.model.ParameterizedJobMixIn;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.jenkinsci.plugins.gwt.jobfinder.GenericTriggerFinder;

public class JobFinderImpersonater {
    private static Logger LOGGER = Logger.getLogger(JobFinderImpersonater.class.getName());
    private static final Map<String, ParameterizedJobMixIn.ParameterizedJob> JOBS_WITH_GWT = new ConcurrentHashMap<String, ParameterizedJobMixIn.ParameterizedJob>();

    public List<ParameterizedJobMixIn.ParameterizedJob> getAllParameterizedJobs(boolean impersonate) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("There are " + JOBS_WITH_GWT.size() + " jobs in cache:");
            TreeSet<String> sortedSet = new TreeSet<String>(JOBS_WITH_GWT.keySet());
            for (String job : sortedSet) {
                LOGGER.finest("  " + job);
            }
        }
        if (impersonate) {
            LOGGER.log(Level.FINE, "Using the cache");
            return new ArrayList<ParameterizedJobMixIn.ParameterizedJob>(JOBS_WITH_GWT.values());
        }
        LOGGER.log(Level.FINE, "Not using the cache because jobs are not retreieved with impersonation SYSTEM. SYSTEM is only impersonated when using a token. If SYSTEM is not impersonated, only jobs available for the currently authenticated user is found.");
        return JobFinderImpersonater.doGetAllParameterizedJobs(impersonate);
    }

    private static List<ParameterizedJobMixIn.ParameterizedJob> doGetAllParameterizedJobs(boolean impersonate) {
        SecurityContext orig = null;
        try {
            if (impersonate) {
                orig = ACL.impersonate((Authentication)ACL.SYSTEM);
            }
            List list = Jenkins.getInstance().getAllItems(ParameterizedJobMixIn.ParameterizedJob.class);
            return list;
        }
        finally {
            if (impersonate) {
                SecurityContextHolder.setContext((SecurityContext)orig);
            }
        }
    }

    private static void putJob(Item job) {
        if (job instanceof ParameterizedJobMixIn.ParameterizedJob) {
            boolean hasGenericTrigger;
            ParameterizedJobMixIn.ParameterizedJob parameterizedJob = (ParameterizedJobMixIn.ParameterizedJob)job;
            boolean bl = hasGenericTrigger = GenericTriggerFinder.findGenericTrigger(parameterizedJob.getTriggers()) != null;
            if (hasGenericTrigger) {
                JOBS_WITH_GWT.put(parameterizedJob.getFullName(), parameterizedJob);
            }
        }
    }

    private static void deleteJob(Item job) {
        JOBS_WITH_GWT.remove(job.getFullName());
    }

    @Extension
    public static class JobItemSaveListener
    extends SaveableListener {
        public void onChange(Saveable o, XmlFile file) {
            if (o instanceof ParameterizedJobMixIn.ParameterizedJob) {
                ParameterizedJobMixIn.ParameterizedJob job = (ParameterizedJobMixIn.ParameterizedJob)o;
                LOGGER.finest("Saving " + job.getFullName());
                JobFinderImpersonater.putJob((Item)job);
            }
        }
    }

    @Extension
    public static class JobItemListener
    extends ItemListener {
        public void onLoaded() {
            for (ParameterizedJobMixIn.ParameterizedJob job : JobFinderImpersonater.doGetAllParameterizedJobs(true)) {
                JobFinderImpersonater.putJob((Item)job);
            }
            LOGGER.info("Loaded " + JOBS_WITH_GWT.size() + " jobs in cache");
        }

        public void onUpdated(Item job) {
            JobFinderImpersonater.putJob(job);
        }

        public void onCreated(Item job) {
            JobFinderImpersonater.putJob(job);
        }

        public void onDeleted(Item job) {
            JobFinderImpersonater.deleteJob(job);
        }

        public void onCopied(Item src, Item job) {
            JobFinderImpersonater.putJob(job);
        }

        public void onLocationChanged(Item item, String oldFullName, String newFullName) {
            JOBS_WITH_GWT.remove(oldFullName);
            JobFinderImpersonater.putJob(item);
        }
    }
}

