/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import hudson.Util;
import hudson.plugins.git.Branch;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean(defaultVisibility=999)
public class Revision
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -7203898556389073882L;
    ObjectId sha1;
    Collection<Branch> branches;

    public Revision(ObjectId sha1) {
        this.sha1 = sha1;
        this.branches = new ArrayList<Branch>();
    }

    public Revision(ObjectId sha1, Collection<Branch> branches) {
        this.sha1 = sha1;
        this.branches = branches;
    }

    public ObjectId getSha1() {
        return this.sha1;
    }

    @Exported(name="SHA1")
    public String getSha1String() {
        return this.sha1 == null ? "" : this.sha1.name();
    }

    public void setSha1(ObjectId sha1) {
        this.sha1 = sha1;
    }

    @Exported(name="branch")
    public Collection<Branch> getBranches() {
        return this.branches;
    }

    public void setBranches(Collection<Branch> branches) {
        this.branches = branches;
    }

    public boolean containsBranchName(String name) {
        for (Branch b : this.branches) {
            if (!b.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        String revisionName = this.sha1 != null ? this.sha1.name() : "null";
        StringBuilder s = new StringBuilder("Revision " + revisionName + " (");
        if (this.branches != null) {
            Joiner.on((String)", ").appendTo(s, Iterables.transform(this.branches, from -> Util.fixNull((String)from.getName())));
        }
        s.append(')');
        return s.toString();
    }

    public Revision clone() {
        Revision clone;
        try {
            clone = (Revision)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Error cloning Revision", e);
        }
        clone.branches = new ArrayList<Branch>(this.branches);
        return clone;
    }

    public int hashCode() {
        return this.sha1 != null ? 31 + this.sha1.hashCode() : 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Revision)) {
            return false;
        }
        Revision other = (Revision)obj;
        if (other.sha1 != null) {
            return other.sha1.equals((AnyObjectId)this.sha1);
        }
        return this.sha1 == null;
    }
}

