/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.TaskAction;
import hudson.model.TaskListener;
import hudson.model.TaskThread;
import hudson.plugins.git.Branch;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.util.BuildData;
import hudson.scm.AbstractScmTagAction;
import hudson.security.Permission;
import hudson.util.CopyOnWriteMap;
import hudson.util.MultipartFormDataParser;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.gitclient.Git;
import org.jenkinsci.plugins.gitclient.GitClient;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.export.ExportedBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ExportedBean
public class GitTagAction
extends AbstractScmTagAction
implements Describable<GitTagAction> {
    private final Map<String, List<String>> tags = new CopyOnWriteMap.Tree();
    private final String ws;

    protected GitTagAction(AbstractBuild build, BuildData buildData) {
        super(build);
        ArrayList val = new ArrayList();
        this.ws = build.getWorkspace().getRemote();
        for (Branch b : buildData.lastBuild.revision.getBranches()) {
            this.tags.put(b.getName(), new ArrayList());
        }
    }

    public Descriptor<GitTagAction> getDescriptor() {
        return Jenkins.getInstance().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public boolean isTagged() {
        for (List<String> t : this.tags.values()) {
            if (t.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public String getIconFileName() {
        if (!this.isTagged() && !this.getACL().hasPermission(this.getPermission())) {
            return null;
        }
        return "save.gif";
    }

    public String getDisplayName() {
        int nonNullTag = 0;
        for (List<String> v : this.tags.values()) {
            if (!v.isEmpty() && (nonNullTag += v.size()) > 1) break;
        }
        if (nonNullTag == 0) {
            return "No Tags";
        }
        if (nonNullTag == 1) {
            return "There is one tag";
        }
        return "There are more than one tag";
    }

    public Map<String, List<String>> getTags() {
        return Collections.unmodifiableMap(this.tags);
    }

    @Exported(name="tags")
    public List<TagInfo> getTagInfo() {
        ArrayList<TagInfo> data = new ArrayList<TagInfo>();
        for (Map.Entry<String, List<String>> e : this.tags.entrySet()) {
            String module = e.getKey();
            for (String tag : e.getValue()) {
                data.add(new TagInfo(module, tag));
            }
        }
        return data;
    }

    public String getTooltip() {
        String tag = null;
        for (List<String> v : this.tags.values()) {
            for (String s : v) {
                if (tag != null) {
                    return "Tagged";
                }
                tag = s;
            }
        }
        if (tag != null) {
            return "Tag: " + tag;
        }
        return null;
    }

    public synchronized void doSubmit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException {
        this.getACL().checkPermission(this.getPermission());
        MultipartFormDataParser parser = new MultipartFormDataParser((HttpServletRequest)req);
        HashMap<String, String> newTags = new HashMap<String, String>();
        int i = -1;
        for (String e : this.tags.keySet()) {
            if (this.tags.size() > 1 && parser.get("tag" + ++i) == null) continue;
            newTags.put(e, parser.get("name" + i));
        }
        new TagWorkerThread(newTags, parser.get("comment")).start();
        rsp.sendRedirect(".");
    }

    public Permission getPermission() {
        return GitSCM.TAG;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends Descriptor<GitTagAction> {
        public String getDisplayName() {
            return "Tag";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class TagWorkerThread
    extends TaskThread {
        private final Map<String, String> tagSet;
        private final String comment;

        public TagWorkerThread(Map<String, String> tagSet, String comment) {
            super((TaskAction)GitTagAction.this, TaskThread.ListenerAndText.forMemory());
            this.tagSet = tagSet;
            this.comment = comment;
        }

        protected void perform(TaskListener listener) throws Exception {
            EnvVars environment = GitTagAction.this.build.getEnvironment(listener);
            FilePath workspace = new FilePath(new File(GitTagAction.this.ws));
            GitClient git = Git.with((TaskListener)listener, (EnvVars)environment).in(workspace).getClient();
            for (String b : this.tagSet.keySet()) {
                try {
                    String buildNum = "jenkins-" + GitTagAction.this.build.getProject().getName().replace(" ", "_") + "-" + this.tagSet.get(b);
                    git.tag(this.tagSet.get(b), "Jenkins Build #" + buildNum);
                    for (Map.Entry<String, String> e : this.tagSet.entrySet()) {
                        ((List)GitTagAction.this.tags.get(e.getKey())).add(e.getValue());
                    }
                    GitTagAction.this.getBuild().save();
                    GitTagAction.this.workerThread = null;
                }
                catch (GitException ex) {
                    ex.printStackTrace(listener.error("Error taggin repo '%s' : %s", new Object[]{b, ex.getMessage()}));
                    listener.getLogger().println("Trying next branch");
                }
            }
        }
    }

    @ExportedBean
    public static class TagInfo {
        private String module;
        private String url;

        private TagInfo(String branch, String tag) {
            this.module = branch;
            this.url = tag;
        }

        @Exported
        public String getBranch() {
            return this.module;
        }

        @Exported
        public String getTag() {
            return this.url;
        }
    }
}

