/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.git.RevisionParameterAction;
import hudson.plugins.git.util.BuildData;
import hudson.plugins.parameterizedtrigger.AbstractBuildParameters;
import hudson.plugins.promoted_builds.Promotion;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;

public class GitRevisionBuildParameters
extends AbstractBuildParameters {
    private boolean combineQueuedCommits = false;

    @DataBoundConstructor
    public GitRevisionBuildParameters(boolean combineQueuedCommits) {
        this.combineQueuedCommits = combineQueuedCommits;
    }

    public GitRevisionBuildParameters() {
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Jenkins.getInstance() is not null")
    public Action getAction(AbstractBuild<?, ?> build, TaskListener listener) {
        BuildData data = (BuildData)build.getAction(BuildData.class);
        if (data == null && Jenkins.getInstance().getPlugin("promoted-builds") != null && build instanceof Promotion) {
            data = (BuildData)((Promotion)build).getTarget().getAction(BuildData.class);
        }
        if (data == null) {
            listener.getLogger().println("This project doesn't use Git as SCM. Can't pass the revision to downstream");
            return null;
        }
        return new RevisionParameterAction(data.getLastBuiltRevision(), this.getCombineQueuedCommits());
    }

    public boolean getCombineQueuedCommits() {
        return this.combineQueuedCommits;
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends Descriptor<AbstractBuildParameters> {
        public String getDisplayName() {
            return "Pass-through Git Commit that was built";
        }
    }
}

