/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.git.browser;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.git.GitChangeSet;
import hudson.plugins.git.browser.GitRepositoryBrowser;
import hudson.scm.EditType;
import hudson.scm.RepositoryBrowser;
import hudson.util.FormValidation;
import java.io.IOException;
import java.net.URL;
import javax.servlet.ServletException;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;

public class GitLab
extends GitRepositoryBrowser {
    private static final long serialVersionUID = 1L;
    private Double version;

    private static double valueOfVersion(String version) throws NumberFormatException {
        double tmpVersion = Double.parseDouble(version);
        if (Double.isNaN(tmpVersion)) {
            throw new NumberFormatException("Version cannot be NaN (not a number)");
        }
        if (Double.isInfinite(tmpVersion)) {
            throw new NumberFormatException("Version cannot be infinite");
        }
        return tmpVersion;
    }

    @DataBoundConstructor
    public GitLab(String repoUrl) {
        super(repoUrl);
    }

    @Deprecated
    public GitLab(String repoUrl, String version) {
        super(repoUrl);
        this.setVersion(version);
    }

    @DataBoundSetter
    public void setVersion(String version) {
        try {
            this.version = GitLab.valueOfVersion(version);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public String getVersion() {
        return this.version != null ? String.valueOf(this.version) : null;
    }

    double getVersionDouble() {
        return this.version != null ? this.version : Double.POSITIVE_INFINITY;
    }

    public URL getChangeSetLink(GitChangeSet changeSet) throws IOException {
        return new URL(this.getUrl(), this.calculatePrefix() + changeSet.getId());
    }

    @Override
    public URL getDiffLink(GitChangeSet.Path path) throws IOException {
        GitChangeSet changeSet = path.getChangeSet();
        String filelink = this.getVersionDouble() < 8.0 ? "#" + path.getPath() : "#diff-" + String.valueOf(this.getIndexOfPath(path));
        return new URL(this.getUrl(), this.calculatePrefix() + changeSet.getId() + filelink);
    }

    @Override
    public URL getFileLink(GitChangeSet.Path path) throws IOException {
        if (path.getEditType().equals(EditType.DELETE)) {
            return this.getDiffLink(path);
        }
        if (this.getVersionDouble() <= 4.2) {
            return GitLab.encodeURL(new URL(this.getUrl(), "tree/" + path.getChangeSet().getId() + "/" + path.getPath()));
        }
        if (this.getVersionDouble() < 5.1) {
            return GitLab.encodeURL(new URL(this.getUrl(), path.getChangeSet().getId() + "/tree/" + path.getPath()));
        }
        return GitLab.encodeURL(new URL(this.getUrl(), "blob/" + path.getChangeSet().getId() + "/" + path.getPath()));
    }

    private String calculatePrefix() {
        if (this.getVersionDouble() < 3.0) {
            return "commits/";
        }
        return "commit/";
    }

    @Extension
    public static class GitLabDescriptor
    extends Descriptor<RepositoryBrowser<?>> {
        @NonNull
        public String getDisplayName() {
            return "gitlab";
        }

        public GitLab newInstance(StaplerRequest req, @NonNull JSONObject jsonObject) throws Descriptor.FormException {
            assert (req != null);
            return (GitLab)((Object)req.bindJSON(GitLab.class, jsonObject));
        }

        public FormValidation doCheckVersion(@QueryParameter(fixEmpty=true) String version) throws IOException, ServletException {
            if (version == null) {
                return FormValidation.ok();
            }
            try {
                GitLab.valueOfVersion(version);
            }
            catch (NumberFormatException nfe) {
                return FormValidation.error((String)("Can't convert '" + version + "' to a number: " + nfe.getMessage()));
            }
            return FormValidation.ok();
        }
    }
}

