/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.httpclient.apache.httpcomponents;

import com.atlassian.httpclient.apache.httpcomponents.PromiseHttpAsyncClient;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.apache.http.protocol.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CompletableFuturePromiseHttpPromiseAsyncClient<C>
implements PromiseHttpAsyncClient {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final CloseableHttpAsyncClient client;
    private final ThreadLocalContextManager<C> threadLocalContextManager;
    private final Executor executor;

    CompletableFuturePromiseHttpPromiseAsyncClient(CloseableHttpAsyncClient client, ThreadLocalContextManager<C> threadLocalContextManager, Executor executor) {
        this.client = Objects.requireNonNull(client);
        this.threadLocalContextManager = Objects.requireNonNull(threadLocalContextManager);
        this.executor = new ThreadLocalDelegateExecutor<C>(threadLocalContextManager, executor);
    }

    @Override
    public Promise<HttpResponse> execute(HttpUriRequest request, HttpContext context) {
        final CompletableFuture future = new CompletableFuture();
        Future clientFuture = this.client.execute(request, context, (FutureCallback)new ThreadLocalContextAwareFutureCallback<C>(this.threadLocalContextManager){

            @Override
            void doCompleted(HttpResponse httpResponse) {
                CompletableFuturePromiseHttpPromiseAsyncClient.this.executor.execute(() -> future.complete(httpResponse));
                CompletableFuturePromiseHttpPromiseAsyncClient.this.log.trace("Closing in doCompleted()");
                CompletableFuturePromiseHttpPromiseAsyncClient.this.closeClient();
            }

            @Override
            void doFailed(Exception ex) {
                CompletableFuturePromiseHttpPromiseAsyncClient.this.executor.execute(() -> future.completeExceptionally(ex));
                CompletableFuturePromiseHttpPromiseAsyncClient.this.log.trace("Closing in doFailed()");
                CompletableFuturePromiseHttpPromiseAsyncClient.this.closeClient();
            }

            @Override
            void doCancelled() {
                TimeoutException timeoutException = new TimeoutException();
                CompletableFuturePromiseHttpPromiseAsyncClient.this.executor.execute(() -> future.completeExceptionally(timeoutException));
                CompletableFuturePromiseHttpPromiseAsyncClient.this.log.trace("Closing in doCancelled()");
                CompletableFuturePromiseHttpPromiseAsyncClient.this.closeClient();
            }
        });
        return Promises.forFuture((Future)clientFuture, (Executor)this.executor);
    }

    private void closeClient() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            this.log.error("Close failed", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <C> void runInContext(ThreadLocalContextManager<C> threadLocalContextManager, C threadLocalContext, ClassLoader contextClassLoader, Runnable runnable) {
        Object oldThreadLocalContext = threadLocalContextManager.getThreadLocalContext();
        ClassLoader oldCcl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
            threadLocalContextManager.setThreadLocalContext(threadLocalContext);
            runnable.run();
        }
        finally {
            threadLocalContextManager.setThreadLocalContext(oldThreadLocalContext);
            Thread.currentThread().setContextClassLoader(oldCcl);
        }
    }

    private static final class ThreadLocalDelegateExecutor<C>
    implements Executor {
        private final Executor delegate;
        private final ThreadLocalContextManager<C> manager;

        ThreadLocalDelegateExecutor(ThreadLocalContextManager<C> manager, Executor delegate) {
            this.delegate = Objects.requireNonNull(delegate);
            this.manager = Objects.requireNonNull(manager);
        }

        @Override
        public void execute(Runnable runnable) {
            this.delegate.execute(new ThreadLocalDelegateRunnable<C>(this.manager, runnable));
        }
    }

    private static final class ThreadLocalDelegateRunnable<C>
    implements Runnable {
        private final C context;
        private final Runnable delegate;
        private final ClassLoader contextClassLoader;
        private final ThreadLocalContextManager<C> manager;

        ThreadLocalDelegateRunnable(ThreadLocalContextManager<C> manager, Runnable delegate) {
            this.delegate = delegate;
            this.manager = manager;
            this.context = manager.getThreadLocalContext();
            this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        }

        @Override
        public void run() {
            CompletableFuturePromiseHttpPromiseAsyncClient.runInContext(this.manager, this.context, this.contextClassLoader, this.delegate);
        }
    }

    private static abstract class ThreadLocalContextAwareFutureCallback<C>
    implements FutureCallback<HttpResponse> {
        private final ThreadLocalContextManager<C> threadLocalContextManager;
        private final C threadLocalContext;
        private final ClassLoader contextClassLoader;

        private ThreadLocalContextAwareFutureCallback(ThreadLocalContextManager<C> threadLocalContextManager) {
            this.threadLocalContextManager = Objects.requireNonNull(threadLocalContextManager);
            this.threadLocalContext = threadLocalContextManager.getThreadLocalContext();
            this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        }

        abstract void doCompleted(HttpResponse var1);

        abstract void doFailed(Exception var1);

        abstract void doCancelled();

        public final void completed(HttpResponse response) {
            CompletableFuturePromiseHttpPromiseAsyncClient.runInContext(this.threadLocalContextManager, this.threadLocalContext, this.contextClassLoader, () -> this.doCompleted(response));
        }

        public final void failed(Exception ex) {
            CompletableFuturePromiseHttpPromiseAsyncClient.runInContext(this.threadLocalContextManager, this.threadLocalContext, this.contextClassLoader, () -> this.doFailed(ex));
        }

        public final void cancelled() {
            CompletableFuturePromiseHttpPromiseAsyncClient.runInContext(this.threadLocalContextManager, this.threadLocalContext, this.contextClassLoader, this::doCancelled);
        }
    }
}

