/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.jira.listissuesparameter;

import hudson.EnvVars;
import hudson.model.AbstractBuild;
import hudson.model.ParameterValue;
import hudson.model.Run;
import hudson.util.VariableResolver;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.export.Exported;

public class JiraIssueParameterValue
extends ParameterValue {
    private static final long serialVersionUID = -1078274709338167211L;
    private String value;

    @DataBoundConstructor
    public JiraIssueParameterValue(String name, String value) {
        super(name);
        this.value = value;
    }

    public void buildEnvironment(Run<?, ?> run, EnvVars env) {
        Object paramValue = this.getValue();
        env.put(this.getName(), paramValue != null ? paramValue.toString() : "");
    }

    public VariableResolver<String> createVariableResolver(AbstractBuild<?, ?> build) {
        return new VariableResolver<String>(){

            public String resolve(String name) {
                if (JiraIssueParameterValue.this.name.equals(name)) {
                    Object paramValue = JiraIssueParameterValue.this.getValue();
                    return paramValue != null ? paramValue.toString() : "";
                }
                return null;
            }
        };
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Exported
    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return "(JiraIssueParameterValue) " + this.getName() + "='" + this.value + "'";
    }
}

