/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.cli;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import hudson.Extension;
import hudson.model.Item;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.jenkinsci.plugins.kubernetes.cli.GenericBuildStep;
import org.jenkinsci.plugins.kubernetes.cli.KubectlCredential;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class KubectlBuildStep
extends Step {
    @DataBoundSetter
    public String serverUrl;
    @DataBoundSetter
    public String credentialsId;
    @DataBoundSetter
    public String caCertificate;
    @DataBoundSetter
    public String contextName;
    @DataBoundSetter
    public String clusterName;
    @DataBoundSetter
    public String namespace;

    @DataBoundConstructor
    public KubectlBuildStep() {
    }

    public final StepExecution start(StepContext context) throws Exception {
        KubectlCredential cred = new KubectlCredential();
        cred.serverUrl = this.serverUrl;
        cred.credentialsId = this.credentialsId;
        cred.caCertificate = this.caCertificate;
        cred.contextName = this.contextName;
        cred.clusterName = this.clusterName;
        cred.namespace = this.namespace;
        ArrayList<KubectlCredential> list = new ArrayList<KubectlCredential>();
        list.add(cred);
        return new GenericBuildStep(list, context);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getDisplayName() {
            return "Configure Kubernetes CLI (kubectl)";
        }

        public String getFunctionName() {
            return "withKubeConfig";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return new HashSet();
        }

        public ListBoxModel doFillCredentialsIdItems(@Nonnull @AncestorInPath Item item, @QueryParameter String serverUrl) {
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM, item, StandardCredentials.class, URIRequirementBuilder.fromUri((String)serverUrl).build(), KubectlCredential.supportedCredentials);
        }
    }
}

