/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.cli;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildWrapperDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jenkins.tasks.SimpleBuildWrapper;
import org.jenkinsci.plugins.kubernetes.cli.KubectlCredential;
import org.jenkinsci.plugins.kubernetes.cli.kubeconfig.KubeConfigWriter;
import org.jenkinsci.plugins.kubernetes.cli.kubeconfig.KubeConfigWriterFactory;
import org.kohsuke.stapler.DataBoundConstructor;

public class MultiKubectlBuildWrapper
extends SimpleBuildWrapper {
    public final transient List<KubectlCredential> kubectlCredentials;

    @DataBoundConstructor
    public MultiKubectlBuildWrapper(List<KubectlCredential> kubectlCredentials) {
        if (kubectlCredentials == null || kubectlCredentials.size() == 0) {
            throw new RuntimeException("Credentials list cannot be empty");
        }
        this.kubectlCredentials = kubectlCredentials;
    }

    public void setUp(SimpleBuildWrapper.Context context, Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener, EnvVars initialEnvironment) throws IOException, InterruptedException {
        ArrayList<String> configFiles = new ArrayList<String>();
        boolean skipUseContext = this.kubectlCredentials.size() >= 2;
        for (KubectlCredential cred : this.kubectlCredentials) {
            KubeConfigWriter kubeConfigWriter = KubeConfigWriterFactory.get(cred.serverUrl, cred.credentialsId, cred.caCertificate, cred.clusterName, cred.contextName, cred.namespace, skipUseContext, workspace, launcher, build);
            configFiles.add(kubeConfigWriter.writeKubeConfig());
        }
        context.setDisposer((SimpleBuildWrapper.Disposer)new CleanupDisposer(configFiles));
        String configFileList = String.join((CharSequence)File.pathSeparator, configFiles);
        context.env("KUBECONFIG", configFileList);
    }

    public static class CleanupDisposer
    extends SimpleBuildWrapper.Disposer {
        private static final long serialVersionUID = 1L;
        private List<String> filesToBeRemoved;

        public CleanupDisposer(List<String> files) {
            this.filesToBeRemoved = files;
        }

        public void tearDown(Run<?, ?> build, FilePath workspace, Launcher launcher, TaskListener listener) throws IOException, InterruptedException {
            for (String file : this.filesToBeRemoved) {
                workspace.child(file).delete();
            }
            listener.getLogger().println("kubectl configuration cleaned up");
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BuildWrapperDescriptor {
        public boolean isApplicable(AbstractProject<?, ?> item) {
            return true;
        }

        public String getDisplayName() {
            return "Configure Kubernetes CLI (kubectl) with multiple credentials";
        }
    }
}

