/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.cli.kubeconfig;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.remoting.Callable;
import io.fabric8.kubernetes.api.model.Cluster;
import io.fabric8.kubernetes.api.model.ConfigBuilder;
import io.fabric8.kubernetes.api.model.ConfigFluent;
import io.fabric8.kubernetes.api.model.NamedCluster;
import io.fabric8.kubernetes.api.model.NamedContextFluent;
import io.fabric8.kubernetes.client.internal.SerializationUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import javax.annotation.Nonnull;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.security.MasterToSlaveCallable;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuth;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthConfig;
import org.jenkinsci.plugins.kubernetes.auth.KubernetesAuthException;
import org.jenkinsci.plugins.kubernetes.auth.impl.KubernetesAuthKubeconfig;
import org.jenkinsci.plugins.kubernetes.credentials.Utils;

public class KubeConfigWriter {
    public static final String ENV_VARIABLE_NAME = "KUBECONFIG";
    private static final String DEFAULT_CONTEXTNAME = "k8s";
    private static final String CLUSTERNAME = "k8s";
    private final String serverUrl;
    private final String credentialsId;
    private final String caCertificate;
    private final String clusterName;
    private final String contextName;
    private final String namespace;
    private final boolean skipUseContext;
    private final FilePath workspace;
    private final Launcher launcher;
    private final Run<?, ?> build;

    public KubeConfigWriter(@Nonnull String serverUrl, @Nonnull String credentialsId, String caCertificate, String clusterName, String contextName, String namespace, boolean skipUseContext, FilePath workspace, Launcher launcher, Run<?, ?> build) {
        this.serverUrl = serverUrl;
        this.credentialsId = credentialsId;
        this.caCertificate = caCertificate;
        this.workspace = workspace;
        this.launcher = launcher;
        this.build = build;
        this.clusterName = clusterName;
        this.contextName = contextName;
        this.namespace = namespace;
        this.skipUseContext = skipUseContext;
    }

    private static ConfigBuilder setNamedCluster(ConfigBuilder configBuilder, NamedCluster cluster) {
        return (ConfigBuilder)((ConfigFluent.ClustersNested)((ConfigFluent.ClustersNested)KubeConfigWriter.existingOrNewCluster(configBuilder, cluster.getName()).withName(cluster.getName())).editOrNewClusterLike(cluster.getCluster()).endCluster()).endCluster();
    }

    private static ConfigBuilder setContextCluster(ConfigBuilder configBuilder, String context, String cluster) {
        return (ConfigBuilder)((ConfigFluent.ContextsNested)((NamedContextFluent.ContextNested)KubeConfigWriter.existingOrNewContext(configBuilder, context).editOrNewContext().withCluster(cluster)).endContext()).endContext();
    }

    private static ConfigBuilder setContextNamespace(ConfigBuilder configBuilder, String context, String namespace) {
        return (ConfigBuilder)((ConfigFluent.ContextsNested)((NamedContextFluent.ContextNested)KubeConfigWriter.existingOrNewContext(configBuilder, context).editOrNewContext().withNamespace(namespace)).endContext()).endContext();
    }

    private static ConfigBuilder setCurrentContext(ConfigBuilder configBuilder, String context) {
        return (ConfigBuilder)configBuilder.withNewCurrentContext(context);
    }

    private static ConfigFluent.ContextsNested<ConfigBuilder> existingOrNewContext(ConfigBuilder configBuilder, String context) {
        if (configBuilder.hasMatchingContext(p -> p.getName().equals(context)).booleanValue()) {
            return configBuilder.editMatchingContext(p -> p.getName().equals(context));
        }
        return configBuilder.addNewContext();
    }

    private static ConfigFluent.ClustersNested<ConfigBuilder> existingOrNewCluster(ConfigBuilder configBuilder, String cluster) {
        if (configBuilder.hasMatchingCluster(p -> p.getName().equals(cluster)).booleanValue()) {
            return configBuilder.editMatchingCluster(p -> p.getName().equals(cluster));
        }
        return configBuilder.addNewCluster();
    }

    public String writeKubeConfig() throws IOException, InterruptedException {
        StandardCredentials credentials;
        if (!this.workspace.exists()) {
            this.launcher.getListener().getLogger().println("creating missing workspace to write kubeconfig");
            this.workspace.mkdirs();
        }
        if ((credentials = (StandardCredentials)CredentialsProvider.findCredentialById((String)this.credentialsId, StandardCredentials.class, this.build, Collections.emptyList())) == null) {
            throw new AbortException("Unable to find credentials with id '" + this.credentialsId + "'");
        }
        KubernetesAuth auth = (KubernetesAuth)AuthenticationTokens.convert(KubernetesAuth.class, (Credentials)credentials);
        if (auth == null) {
            throw new AbortException("Unsupported credentials type " + credentials.getClass().getName());
        }
        ConfigBuilder configBuilder = this.getConfigBuilder(credentials.getId(), auth);
        FilePath configFile = this.getTempKubeconfigFilePath();
        configFile.write(SerializationUtils.getMapper().writeValueAsString((Object)configBuilder.build()), String.valueOf(StandardCharsets.UTF_8));
        return configFile.getRemote();
    }

    public ConfigBuilder getConfigBuilder(String credentialsId, KubernetesAuth auth) throws IOException, InterruptedException {
        ConfigBuilder configBuilder;
        try {
            KubernetesAuthConfig authConfig = new KubernetesAuthConfig(this.getServerUrl(), this.caCertificate, !this.wasProvided(this.caCertificate));
            configBuilder = auth.buildConfigBuilder(authConfig, this.getContextNameOrDefault(), this.getClusterNameOrDefault(), credentialsId);
            configBuilder = auth instanceof KubernetesAuthKubeconfig ? this.completeKubeconfigConfigBuilder(configBuilder) : this.completeConfigBuilder(configBuilder);
        }
        catch (KubernetesAuthException e) {
            throw new AbortException(e.getMessage());
        }
        return configBuilder;
    }

    private ConfigBuilder completeConfigBuilder(ConfigBuilder configBuilder) {
        if (this.wasProvided(this.namespace)) {
            configBuilder = KubeConfigWriter.setContextNamespace(configBuilder, this.getContextNameOrDefault(), this.namespace);
        }
        if (!this.skipUseContext) {
            configBuilder = KubeConfigWriter.setCurrentContext(configBuilder, this.getContextNameOrDefault());
        }
        return configBuilder;
    }

    private ConfigBuilder completeKubeconfigConfigBuilder(ConfigBuilder configBuilder) throws IOException, InterruptedException {
        if (this.wasProvided(this.getServerUrl())) {
            configBuilder = KubeConfigWriter.setNamedCluster(configBuilder, this.buildNamedCluster());
        }
        String currentContext = configBuilder.getCurrentContext();
        if (this.wasProvided(this.serverUrl) || this.wasProvided(this.clusterName)) {
            configBuilder = KubeConfigWriter.setContextCluster(configBuilder, currentContext, this.getClusterNameOrDefault());
        }
        if (this.wasProvided(this.namespace)) {
            configBuilder = KubeConfigWriter.setContextNamespace(configBuilder, currentContext, this.namespace);
        }
        if (this.wasProvided(this.contextName) && !this.skipUseContext) {
            configBuilder = KubeConfigWriter.setCurrentContext(configBuilder, this.contextName);
        }
        return configBuilder;
    }

    private NamedCluster buildNamedCluster() throws IOException, InterruptedException {
        Cluster cluster = new Cluster();
        cluster.setServer(this.getServerUrl());
        if (this.wasProvided(this.caCertificate)) {
            cluster.setCertificateAuthorityData(Utils.encodeBase64((String)Utils.wrapCertificate((String)this.caCertificate)));
        }
        cluster.setInsecureSkipTlsVerify(Boolean.valueOf(!this.wasProvided(this.caCertificate)));
        NamedCluster namedCluster = new NamedCluster();
        namedCluster.setCluster(cluster);
        namedCluster.setName(this.getClusterNameOrDefault());
        return namedCluster;
    }

    private boolean wasProvided(String value) {
        return value != null && !value.isEmpty();
    }

    private String getContextNameOrDefault() {
        if (!this.wasProvided(this.contextName)) {
            return "k8s";
        }
        return this.contextName;
    }

    private String getClusterNameOrDefault() {
        if (!this.wasProvided(this.clusterName)) {
            return "k8s";
        }
        return this.clusterName;
    }

    private String getServerUrl() throws IOException, InterruptedException {
        EnvVars env = this.build.getEnvironment(this.launcher.getListener());
        return env.expand(this.serverUrl);
    }

    private FilePath getTempKubeconfigFilePath() throws IOException, InterruptedException {
        String tempFolder = (String)this.workspace.getChannel().call((Callable)new ObtainTemporaryFolderCallable());
        FilePath tempPath = new FilePath(this.workspace.getChannel(), tempFolder);
        if (!tempPath.exists()) {
            this.launcher.getListener().getLogger().println("creating missing temporary folder to write kube config files");
            tempPath.mkdirs();
        }
        return tempPath.createTempFile("kubernetes-cli-plugin-kube", "config");
    }

    private static class ObtainTemporaryFolderCallable
    extends MasterToSlaveCallable<String, IOException> {
        private static final String TMPDIR__PROPERTY = "java.io.tmpdir";

        private ObtainTemporaryFolderCallable() {
        }

        public String call() {
            return System.getProperty(TMPDIR__PROPERTY);
        }
    }
}

