/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps;

import hudson.FilePath;
import java.io.File;
import java.io.IOException;
import jenkins.MasterToSlaveFileCallable;

public abstract class AbstractFileCallable<T>
extends MasterToSlaveFileCallable<T> {
    private FilePath destination;
    private boolean allowExtractionOutsideDestination = false;

    public FilePath getDestination() {
        return this.destination;
    }

    public void setDestination(FilePath destination) {
        this.destination = destination;
    }

    public boolean isAllowExtractionOutsideDestination() {
        return this.allowExtractionOutsideDestination;
    }

    public void setAllowExtractionOutsideDestination(boolean allowExtractionOutsideDestination) {
        this.allowExtractionOutsideDestination = allowExtractionOutsideDestination;
    }

    protected boolean isDescendantOfDestination(FilePath f) throws IOException {
        if (this.allowExtractionOutsideDestination) {
            return true;
        }
        if (this.destination == null) {
            return false;
        }
        File dst = new File(this.destination.getRemote()).getCanonicalFile();
        File child = new File(f.getRemote()).getCanonicalFile();
        return child.toPath().startsWith(dst.toPath());
    }
}

