/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.conf;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import jenkins.util.SystemProperties;
import org.apache.commons.configuration2.AbstractConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationConverter;
import org.apache.commons.configuration2.interpol.ConfigurationInterpolator;
import org.apache.commons.configuration2.interpol.DefaultLookups;
import org.apache.commons.configuration2.interpol.InterpolatorSpecification;
import org.apache.commons.configuration2.interpol.Lookup;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pipeline.utility.steps.AbstractFileOrTextStepExecution;
import org.jenkinsci.plugins.pipeline.utility.steps.conf.ReadPropertiesStep;
import org.jenkinsci.plugins.workflow.steps.StepContext;

public class ReadPropertiesStepExecution
extends AbstractFileOrTextStepExecution<Map<String, Object>> {
    private static final long serialVersionUID = 1L;
    private static final Map<String, Lookup> SAFE_PREFIX_INTERPOLATOR_LOOKUPS = new HashMap<String, Lookup>(){
        {
            this.put(DefaultLookups.BASE64_DECODER.getPrefix(), DefaultLookups.BASE64_DECODER.getLookup());
            this.put(DefaultLookups.BASE64_ENCODER.getPrefix(), DefaultLookups.BASE64_ENCODER.getLookup());
            this.put(DefaultLookups.DATE.getPrefix(), DefaultLookups.DATE.getLookup());
            this.put(DefaultLookups.URL_DECODER.getPrefix(), DefaultLookups.URL_DECODER.getLookup());
            this.put(DefaultLookups.URL_ENCODER.getPrefix(), DefaultLookups.URL_ENCODER.getLookup());
        }
    };
    static String CUSTOM_PREFIX_INTERPOLATOR_LOOKUPS = SystemProperties.getString((String)(ReadPropertiesStepExecution.class.getName() + ".CUSTOM_PREFIX_INTERPOLATOR_LOOKUPS"));
    private transient ReadPropertiesStep step;

    protected ReadPropertiesStepExecution(@NonNull ReadPropertiesStep step, @NonNull StepContext context) {
        super(step, context);
        this.step = step;
    }

    @Override
    protected Map<String, Object> doRun() throws Exception {
        PrintStream logger = this.getLogger();
        Properties properties = new Properties();
        if (this.step.getDefaults() != null) {
            properties.putAll(this.step.getDefaults());
        }
        if (!StringUtils.isBlank((String)this.step.getFile())) {
            FilePath f = this.ws.child(this.step.getFile());
            if (f.exists() && !f.isDirectory()) {
                try (InputStream is = f.read();){
                    if (StringUtils.isEmpty((String)this.step.getCharset())) {
                        properties.load(is);
                    }
                    try (InputStreamReader isr = new InputStreamReader(is, this.step.getCharset());
                         BufferedReader br = new BufferedReader(isr);){
                        properties.load(br);
                    }
                }
            } else if (f.isDirectory()) {
                logger.print("warning: ");
                logger.print(f.getRemote());
                logger.println(" is a directory, omitting from properties gathering");
            } else if (!f.exists()) {
                logger.print("warning: ");
                logger.print(f.getRemote());
                logger.println(" does not exist, omitting from properties gathering");
            }
        }
        if (!StringUtils.isBlank((String)this.step.getText())) {
            StringReader sr = new StringReader(this.step.getText());
            properties.load(sr);
        }
        if (this.step.isInterpolate().booleanValue()) {
            logger.println("Interpolation set to true, starting to parse the variable!");
            properties = this.interpolateProperties(properties);
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        this.addAll(properties, result);
        return result;
    }

    private void addAll(Map<Object, Object> src, Map<String, Object> dst) {
        if (src == null) {
            return;
        }
        for (Map.Entry<Object, Object> e : src.entrySet()) {
            dst.put(e.getKey() != null ? e.getKey().toString() : null, e.getValue());
        }
    }

    private Properties interpolateProperties(Properties properties) throws Exception {
        if (properties == null) {
            return null;
        }
        PrintStream logger = this.getLogger();
        try {
            ConfigurationInterpolator configurationInterpolator = ConfigurationInterpolator.fromSpecification((InterpolatorSpecification)new InterpolatorSpecification.Builder().withPrefixLookups(CUSTOM_PREFIX_INTERPOLATOR_LOOKUPS == null ? SAFE_PREFIX_INTERPOLATOR_LOOKUPS : ReadPropertiesStepExecution.parseLookups(CUSTOM_PREFIX_INTERPOLATOR_LOOKUPS)).create());
            Configuration conf = ConfigurationConverter.getConfiguration((Properties)properties);
            conf.setInterpolator(configurationInterpolator);
            Configuration interpolatedProp = ((AbstractConfiguration)conf).interpolatedConfiguration();
            return ConfigurationConverter.getProperties((Configuration)interpolatedProp);
        }
        catch (Exception e) {
            logger.println("Got exception while interpolating the variables: " + e.getMessage());
            logger.println("Returning the original properties list!");
            return properties;
        }
    }

    private PrintStream getLogger() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        assert (listener != null);
        return listener.getLogger();
    }

    private static Map<String, Lookup> parseLookups(String str) {
        HashMap<String, Lookup> lookupMap = new HashMap<String, Lookup>();
        if (StringUtils.isBlank((String)str)) {
            return lookupMap;
        }
        try {
            for (String lookupName : str.split("[\\s,]+")) {
                if (lookupName.isEmpty()) continue;
                DefaultLookups lookup = DefaultLookups.valueOf((String)lookupName.toUpperCase());
                lookupMap.put(lookup.getPrefix(), lookup.getLookup());
            }
        }
        catch (IllegalArgumentException exc) {
            throw new IllegalArgumentException("Invalid default lookups definition: " + str, exc);
        }
        return lookupMap;
    }
}

