/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.utility.steps.toml;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import java.io.FileNotFoundException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import org.jenkinsci.plugins.pipeline.utility.steps.toml.Messages;
import org.jenkinsci.plugins.pipeline.utility.steps.toml.WriteTOMLStep;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;

public class WriteTOMLStepExecution
extends SynchronousNonBlockingStepExecution<Void> {
    private static final long serialVersionUID = 1L;
    private transient WriteTOMLStep step;

    protected WriteTOMLStepExecution(@NonNull WriteTOMLStep step, @NonNull StepContext context) {
        super(context);
        this.step = step;
    }

    protected Void run() throws Exception {
        FilePath ws = (FilePath)this.getContext().get(FilePath.class);
        if (ws == null) {
            throw new MissingContextVariableException(FilePath.class);
        }
        assert (ws != null);
        FilePath path = ws.child(this.step.getFile());
        if (path.isDirectory()) {
            throw new FileNotFoundException(Messages.TOMLStepExecution_fileIsDirectory(path.getRemote()));
        }
        try (OutputStreamWriter writer = new OutputStreamWriter(path.write(), StandardCharsets.UTF_8);){
            this.step.execute(writer);
        }
        return null;
    }
}

