/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pollmailboxtrigger;

import antlr.ANTLRException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Util;
import hudson.console.AnnotatedLargeText;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Cause;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.JobProperty;
import hudson.model.Node;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.Secret;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Flags;
import javax.mail.FolderNotFoundException;
import javax.mail.Message;
import javax.mail.search.SearchTerm;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.XMLOutput;
import org.jenkinsci.lib.xtrigger.XTriggerCause;
import org.jenkinsci.lib.xtrigger.XTriggerDescriptor;
import org.jenkinsci.lib.xtrigger.XTriggerException;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.pollmailboxtrigger.PollMailboxTriggerAction;
import org.jenkinsci.plugins.pollmailboxtrigger.SafeJenkins;
import org.jenkinsci.plugins.pollmailboxtrigger.TeeLogger;
import org.jenkinsci.plugins.pollmailboxtrigger.environment.SetEnvironmentVariablesAction;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.MailReader;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.CustomProperties;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.Logger;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.MailWrapperUtils;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.SearchTermHelpers;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.Stringify;
import org.jenkinsci.plugins.scripttrigger.AbstractTriggerExt;
import org.jenkinsci.plugins.scripttrigger.LabelRestrictionClass;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PollMailboxTrigger
extends AbstractTriggerExt {
    public static final String DATE_FORMAT_TEXT = "yyyy/MM/dd HH:mm:ss a";
    public static final int ONE_DAY_IN_MINUTES = 1440;
    public static final int PORT_IMAP = 143;
    public static final int PORT_IMAPS = 993;
    public static final int PORT_POP3 = 110;
    public static final int PORT_POP3S = 995;
    public static final String STORE_IMAP = "imap";
    public static final String STORE_IMAPS = "imaps";
    public static final String STORE_POP3 = "pop3";
    public static final String STORE_POP3S = "pop3s";
    public static final String TEST_JOB_START_MODE = "##TEST_JOB_START_MODE##";
    private String host;
    private String username;
    private Secret password;
    private String script;
    private String attachments;

    @DataBoundConstructor
    public PollMailboxTrigger(String cronTabSpec, LabelRestrictionClass labelRestriction, boolean enableConcurrentBuild, String host, String username, Secret password, String script, String attachments) throws ANTLRException {
        super(cronTabSpec, labelRestriction != null, labelRestriction == null ? null : labelRestriction.getTriggerLabel(), enableConcurrentBuild);
        this.host = Util.fixEmpty((String)host);
        this.username = Util.fixEmpty((String)username);
        this.password = password;
        this.script = Util.fixEmpty((String)script);
        this.script = Util.fixEmpty((String)script);
        this.attachments = Util.fixEmpty((String)attachments);
    }

    public static CustomProperties initialiseDefaults(String pHost, String pUsername, Secret password, String pScript, String attachments) {
        int port;
        EnvironmentVariablesNodeProperty envClass;
        DescribableList<NodeProperty<?>, NodePropertyDescriptor> propsNode;
        EnvironmentVariablesNodeProperty envClass2;
        String host = pHost;
        String username = pUsername;
        String script = pScript;
        DescribableList<NodeProperty<?>, NodePropertyDescriptor> properties = SafeJenkins.getGlobalNodeProperties();
        EnvVars envVars = new EnvVars();
        if (null != properties && null != (envClass2 = (EnvironmentVariablesNodeProperty)properties.get(EnvironmentVariablesNodeProperty.class))) {
            envVars.putAll((Map)envClass2.getEnvVars());
        }
        if (null != (propsNode = SafeJenkins.getNodeProperties()) && null != (envClass = (EnvironmentVariablesNodeProperty)propsNode.get(EnvironmentVariablesNodeProperty.class))) {
            envVars.putAll((Map)envClass.getEnvVars());
        }
        host = Util.replaceMacro((String)host, (Map)envVars);
        username = Util.replaceMacro((String)username, (Map)envVars);
        String passwordVariableReplaced = SafeJenkins.nonNull(password) ? Util.replaceMacro((String)password.getPlainText(), (Map)envVars) : "";
        script = Util.replaceMacro((String)script, (Map)envVars);
        CustomProperties userConfig = CustomProperties.read(script);
        CustomProperties p = new CustomProperties();
        p.putAll(userConfig);
        p.put(Properties.host, host);
        p.put(Properties.username, username);
        p.put(Properties.password, SafeJenkins.encrypt(passwordVariableReplaced));
        p.put(Properties.attachments, attachments);
        p.putIfBlank(Properties.storeName, STORE_IMAPS);
        p.putIfBlank(Properties.folder, "INBOX");
        p.putIfBlank(Properties.subjectContains, "jenkins >");
        String cnfHost = p.get(Properties.host);
        String cnfStoreName = p.get(Properties.storeName).toLowerCase();
        int n = STORE_IMAP.equals(cnfStoreName) ? 143 : (STORE_IMAPS.equals(cnfStoreName) ? 993 : (STORE_POP3.equals(cnfStoreName) ? 110 : (port = STORE_POP3S.equals(cnfStoreName) ? 995 : 993)));
        if (!PollMailboxTrigger.isStorePop3(cnfStoreName)) {
            p.putIfBlank(Properties.receivedXMinutesAgo, Integer.toString(1440));
        }
        p.putIfBlank("mail." + cnfStoreName + ".host", cnfHost);
        p.putIfBlank("mail." + cnfStoreName + ".port", String.valueOf(port));
        p.putIfBlank("mail.debug", "false");
        p.putIfBlank("mail.debug.auth", "false");
        p.putAll(userConfig);
        p.removeBlanks();
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FormValidation checkForEmails(CustomProperties properties, XTriggerLog logger, boolean testConnection, PollMailboxTrigger pmt) {
        MailReader mailbox = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT_TEXT);
        TeeLogger log = new TeeLogger(logger, new ArrayList<String>());
        try {
            FormValidation requiredProps = new FormValidation[]{Properties.host, Properties.storeName, Properties.username, Properties.password};
            ArrayList<String> errors = new ArrayList<String>();
            boolean allRequired = true;
            for (Enum prop : requiredProps) {
                if (properties.has(prop)) continue;
                String err = String.format("Email property '%s' is required!", prop);
                log.error(err);
                errors.add(err);
                allRequired = false;
            }
            if (!allRequired) {
                FormValidation arr$ = FormValidation.error((String)("Error : " + Stringify.stringify(errors)));
                return arr$;
            }
            if (properties.get(Properties.host).equals(TEST_JOB_START_MODE)) {
                Object tmp;
                if (!testConnection) {
                    tmp = new HashMap();
                    tmp.put("aaa", "zzz");
                    tmp.put("bbb", "yyy");
                    tmp.put("ccc", "xxx");
                    pmt.startJob(log.getLog(), "Job was triggered by ##TEST_JOB_START_MODE##", (Map<String, String>)tmp);
                }
                tmp = FormValidation.ok((String)TEST_JOB_START_MODE);
                return tmp;
            }
            log.info("Connecting to the mailbox...");
            String encryptedPassword = properties.get(Properties.password);
            String decryptedPassword = SafeJenkins.decrypt(encryptedPassword);
            String storeNameValue = properties.get(Properties.storeName);
            mailbox = new MailReader(properties.get(Properties.host), properties.get(Properties.username), decryptedPassword, storeNameValue, new Logger.XTriggerLoggerWrapper(log.getLog()), properties).connect();
            log.info("Found properties:");
            ArrayList<String> keys = new ArrayList<String>(properties.keySet());
            Collections.sort(keys);
            for (String key : keys) {
                String obfuscatedValue = Properties.password.name().equalsIgnoreCase(key) ? "***" : properties.get(key);
                log.info("- [" + key + ":" + obfuscatedValue + "]");
            }
            log.info("Connected to mailbox. Searching for messages where:");
            ArrayList<SearchTerm> searchTerms = new ArrayList<SearchTerm>();
            searchTerms.add(SearchTermHelpers.not(SearchTermHelpers.flag(Flags.Flag.SEEN)));
            log.info("- [flag is unread]");
            if (properties.has(Properties.subjectContains)) {
                searchTerms.add(SearchTermHelpers.subject(properties.get(Properties.subjectContains)));
                log.info("- [subject contains '" + properties.get(Properties.subjectContains) + "']");
            } else {
                log.info("- [subject contains - filter not set]");
            }
            if (!PollMailboxTrigger.isStorePop3(storeNameValue) && properties.has(Properties.receivedXMinutesAgo)) {
                int minsAgo = Integer.parseInt(properties.get(Properties.receivedXMinutesAgo)) * -1;
                Date date = SearchTermHelpers.relativeDate(12, minsAgo);
                searchTerms.add(SearchTermHelpers.receivedSince(date));
                log.info("- [received date is greater than '" + dateFormat.format(date) + "']");
            } else {
                log.info("- [received date - filter not set]");
            }
            log.info("...");
            if (!properties.has(Properties.folder)) {
                throw new FolderNotFoundException();
            }
            MailWrapperUtils.FolderWrapper mbFolder = mailbox.folder(properties.get(Properties.folder));
            log.info("Searching folder...");
            String downloadAttachments = properties.get(Properties.attachments);
            MailWrapperUtils.MessagesWrapper messagesTool = mbFolder.search(searchTerms);
            List<Message> messageList = messagesTool.getMessages();
            StringBuilder subjects = new StringBuilder();
            for (Message message : messageList) {
                Date receivedDate = message.getReceivedDate();
                subjects.append("\n\n- ").append(message.getSubject()).append(" (").append(receivedDate != null ? dateFormat.format(receivedDate) : "null").append(")");
            }
            String foundEmails = "Found matching email(s) : " + messageList.size() + subjects.toString();
            log.info(foundEmails);
            if (!testConnection) {
                for (Message message : messageList) {
                    File attachmentsDir;
                    String prefix = "pmt_";
                    CustomProperties buildParams = messagesTool.getMessageProperties(message, "pmt_", properties);
                    log.info("Download attachments? " + downloadAttachments);
                    if (AttachmentOptions.AUTO.name().equals(downloadAttachments) && SafeJenkins.nonNull(attachmentsDir = messagesTool.saveAttachments(message))) {
                        buildParams.put("pmt_attachmentsDirectory", attachmentsDir.getAbsolutePath());
                    }
                    properties.remove(Properties.password);
                    buildParams.putAll(properties, "pmt_");
                    buildParams.put("pmt_retryEmailLink", PollMailboxTrigger.buildEmailRetryLink(buildParams));
                    String jobCause = "Job was triggered by email sent from " + Stringify.stringify(message.getFrom());
                    pmt.startJob(log.getLog(), jobCause, buildParams.getMap());
                    messagesTool.markAsRead(message);
                }
            } else {
                log.info("'Test connection' mode enabled - server connection skipped");
            }
            if (testConnection) {
                log.info("\nResult: Success!");
                FormValidation formValidation = FormValidation.ok((String)Stringify.stringify(log.getTesting(), "\n"));
                return formValidation;
            }
        }
        catch (FolderNotFoundException e) {
            try {
                log.info("Please set the 'folder=XXX' parameter to one of the following values: ");
                String folders = Stringify.stringify(mailbox.getFolders());
                log.info("Folders: " + folders);
                log.info(folders);
                FormValidation formValidation = FormValidation.error((String)Stringify.stringify(log.getTesting(), "\n"));
                return formValidation;
            }
            catch (Throwable t) {
                FormValidation formValidation = PollMailboxTrigger.handleError(log.getLog(), log.getTesting(), t);
                return formValidation;
            }
        }
        catch (Throwable t) {
            FormValidation formValidation = PollMailboxTrigger.handleError(log.getLog(), log.getTesting(), t);
            return formValidation;
        }
        finally {
            if (mailbox != null) {
                mailbox.close();
            }
        }
        return FormValidation.ok((String)"Success");
    }

    private static boolean isStorePop3(String storeName) {
        return STORE_POP3.equals(storeName) || STORE_POP3S.equals(storeName);
    }

    public static String buildEmailRetryLink(CustomProperties properties) {
        String recipients = properties.get("pmt_recipients");
        String subject = properties.get("pmt_subject");
        String body = properties.get("pmt_content");
        String htmlNewline = "%0D%0A";
        if (SafeJenkins.nonNull(body)) {
            body = body.replaceAll("\r\n", htmlNewline).replaceAll("\n", htmlNewline).replaceAll("\"", "&quot;");
        }
        return String.format("<a href=\"mailto:%s?subject=%s&body=%s\">Click to Retry Job</a>", recipients, subject, body);
    }

    private static FormValidation handleError(XTriggerLog log, List<String> testing, Throwable t) {
        String error = Stringify.stringify(t);
        log.error(error);
        testing.add("Error : " + error);
        return FormValidation.error((String)Stringify.stringify(testing, "\n"));
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Secret getPassword() {
        return this.password;
    }

    public void setPassword(Secret password) {
        this.password = password;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getAttachments() {
        return this.attachments;
    }

    public void setAttachments(String attachments) {
        this.attachments = attachments;
    }

    public Collection<? extends Action> getProjectActions() {
        InternalPollMailboxTriggerAction action = new InternalPollMailboxTriggerAction(this.getDescriptor().getDisplayName());
        return Collections.singleton(action);
    }

    @Override
    protected String getName() {
        return "PollMailboxTrigger";
    }

    public PollMailboxTriggerDescriptor getDescriptor() {
        Descriptor descriptor;
        Jenkins instance = Jenkins.getInstance();
        if (instance != null && (descriptor = instance.getDescriptorOrDie(((Object)((Object)this)).getClass())) != null && descriptor instanceof PollMailboxTriggerDescriptor) {
            return (PollMailboxTriggerDescriptor)descriptor;
        }
        return null;
    }

    protected File getLogFile() {
        if (this.job != null) {
            return new File(((BuildableItem)this.job).getRootDir(), "pollMailboxTrigger-polling.log");
        }
        return new File("pollMailboxTrigger-polling.log");
    }

    @Override
    protected String getDefaultMessageCause() {
        return "An email matching the filter criteria was found.";
    }

    protected boolean checkIfModified(Node executingNode, XTriggerLog log) {
        CustomProperties properties = PollMailboxTrigger.initialiseDefaults(this.host, this.username, this.password, this.script, this.attachments);
        PollMailboxTrigger.checkForEmails(properties, log, false, this);
        return false;
    }

    protected void startJob(XTriggerLog log, String jobTriggerCause, Map<String, String> envVars) throws Throwable {
        try {
            log.info("Changes found. Scheduling a build.");
            AbstractProject project = this.getJob();
            ArrayList<Object> actions = new ArrayList<Object>();
            actions.addAll(this.getScheduledXTriggerActions(log));
            ArrayList<ParameterValue> buildParams = new ArrayList<ParameterValue>();
            buildParams.addAll(this.getParameterizedParams(log, project, envVars));
            if (!buildParams.isEmpty()) {
                actions.add(new ParametersAction(buildParams));
            }
            if (!envVars.isEmpty()) {
                actions.add(new SetEnvironmentVariablesAction(envVars));
            }
            NewEmailCause cause = new NewEmailCause(this.getName(), jobTriggerCause, true);
            Action[] actionsArray = actions.toArray(new Action[actions.size()]);
            project.scheduleBuild(0, (Cause)cause, actionsArray);
        }
        catch (Throwable t) {
            log.error("Error occurred starting job - " + t.getMessage());
            throw t;
        }
    }

    protected AbstractProject getJob() {
        return (AbstractProject)this.job;
    }

    protected List<Action> getScheduledXTriggerActions(XTriggerLog log) throws XTriggerException {
        return Arrays.asList(this.getScheduledXTriggerActions(null, log));
    }

    private List<ParameterValue> convertToBuildParams(Map<String, String> envVars) {
        ArrayList<ParameterValue> buildParams = new ArrayList<ParameterValue>();
        for (Map.Entry<String, String> entry : envVars.entrySet()) {
            if (entry.getValue() == null) continue;
            buildParams.add((ParameterValue)new StringParameterValue(entry.getKey(), entry.getValue()));
        }
        return buildParams;
    }

    private List<ParameterValue> getParameterizedParams(XTriggerLog log, AbstractProject project, Map<String, String> envVars) {
        ArrayList<ParameterValue> buildParams = new ArrayList<ParameterValue>();
        if (project.isParameterized()) {
            JobProperty properties = project.getProperty(ParametersDefinitionProperty.class);
            if (properties != null && properties instanceof ParametersDefinitionProperty) {
                ParametersDefinitionProperty parameterizedProperties = (ParametersDefinitionProperty)properties;
                for (ParameterDefinition parameterDef : parameterizedProperties.getParameterDefinitions()) {
                    String parameterName = parameterDef.getName();
                    ParameterValue parameterValue = parameterDef.getDefaultParameterValue();
                    if (envVars.containsKey(parameterName)) {
                        if (parameterDef instanceof SimpleParameterDefinition) {
                            SimpleParameterDefinition simpleParamDef = (SimpleParameterDefinition)parameterDef;
                            String newValue = envVars.get(parameterName);
                            log.info(String.format("Replacing default parameter '%s' with value '%s'", parameterName, newValue));
                            parameterValue = simpleParamDef.createValue(newValue);
                        } else {
                            log.info(String.format("Job property '%s' is not a Simple parameter. Keeping default value.", parameterName));
                        }
                        envVars.remove(parameterName);
                    } else {
                        log.info(String.format("Job property '%s' doesn't exist in env vars, using default value.", parameterName));
                    }
                    buildParams.add(parameterValue);
                }
            } else {
                log.info("Job has no properties.");
            }
        } else {
            log.info("Job has no parameters.");
        }
        return buildParams;
    }

    public final class InternalPollMailboxTriggerAction
    extends PollMailboxTriggerAction {
        private transient String actionTitle;

        public InternalPollMailboxTriggerAction(String actionTitle) {
            this.actionTitle = actionTitle;
        }

        public AbstractProject<?, ?> getOwner() {
            return (AbstractProject)PollMailboxTrigger.this.job;
        }

        public String getDisplayName() {
            return "Poll Mailbox Trigger Log";
        }

        public String getUrlName() {
            return "pollMailboxTriggerLog";
        }

        public String getIconFileName() {
            return "clipboard.gif";
        }

        public String getLabel() {
            return this.actionTitle;
        }

        public String getLog() throws IOException {
            return Util.loadFile((File)PollMailboxTrigger.this.getLogFile());
        }

        public void writeLogTo(XMLOutput out) throws IOException {
            new AnnotatedLargeText(PollMailboxTrigger.this.getLogFile(), Charset.defaultCharset(), true, (Object)this).writeHtmlTo(0L, out.asWriter());
        }
    }

    static class NewEmailCause
    extends XTriggerCause {
        protected NewEmailCause(String triggerName, String causeFrom, boolean logEnabled) {
            super(triggerName, causeFrom, logEnabled);
        }
    }

    @Extension
    public static class PollMailboxTriggerDescriptor
    extends XTriggerDescriptor {
        public boolean isApplicable(Item item) {
            return true;
        }

        public String getDisplayName() {
            return "Poll Mailbox Trigger";
        }

        public String getHelpFile() {
            return "/plugin/poll-mailbox-trigger/help-PollMailboxTrigger.html";
        }

        public FormValidation doTestConnection(@QueryParameter(value="host") String host, @QueryParameter(value="username") String username, @QueryParameter(value="password") Secret password, @QueryParameter(value="script") String script, @QueryParameter(value="attachments") String attachments) {
            try {
                CustomProperties properties = PollMailboxTrigger.initialiseDefaults(host, username, password, script, attachments);
                return PollMailboxTrigger.checkForEmails(properties, new XTriggerLog(new StreamTaskListener(Logger.getDefault().getOutputStream())), true, null);
            }
            catch (Throwable t) {
                return FormValidation.error((String)("Error : " + Stringify.stringify(t)));
            }
        }
    }

    public static enum Properties {
        storeName,
        host,
        username,
        password,
        folder,
        subjectContains,
        receivedXMinutesAgo,
        attachments;

    }

    static enum AttachmentOptions {
        IGNORE,
        AUTO;

    }
}

