/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pollmailboxtrigger;

import hudson.model.Saveable;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.DescribableList;
import hudson.util.Secret;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import jenkins.model.Jenkins;

public final class SafeJenkins {
    private static DescribableList<NodeProperty<?>, NodePropertyDescriptor> globalNodeProperties = null;
    private static DescribableList<NodeProperty<?>, NodePropertyDescriptor> localNodeProperties = null;
    private static boolean useNativeInstance = true;

    private SafeJenkins() {
    }

    public static void useNativeInstance(boolean useNativeInstance) {
        SafeJenkins.useNativeInstance = useNativeInstance;
    }

    public static Jenkins getJenkinsInstance() {
        if (useNativeInstance) {
            Jenkins instance = Jenkins.getInstance();
            if (SafeJenkins.isNull(instance)) {
                throw new RuntimeException("Could not get Jenkins instance using Jenkins.getInstance() (returns null). This can happen if Jenkins has not been started, or was already shut down. Please see http://javadoc.jenkins-ci.org/jenkins/model/Jenkins.html#getInstance() for more details. If you believe this is an error, please raise an 'issue' under https://wiki.jenkins-ci.org/display/JENKINS/poll-mailbox-trigger-plugin.");
            }
            return instance;
        }
        throw new RuntimeException("This method is not supported!");
    }

    public static DescribableList<NodeProperty<?>, NodePropertyDescriptor> getGlobalNodeProperties() {
        return useNativeInstance ? SafeJenkins.getJenkinsInstance().getGlobalNodeProperties() : globalNodeProperties;
    }

    public static DescribableList<NodeProperty<?>, NodePropertyDescriptor> getNodeProperties() {
        return useNativeInstance ? SafeJenkins.getJenkinsInstance().getNodeProperties() : localNodeProperties;
    }

    public static void setLocalNodeProperties(Map<String, String> properties) {
        if (SafeJenkins.isNull(localNodeProperties)) {
            localNodeProperties = new DescribableList((Saveable)new NoopSaveable());
        }
        ArrayList<EnvironmentVariablesNodeProperty.Entry> envVarEntries = new ArrayList<EnvironmentVariablesNodeProperty.Entry>();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            envVarEntries.add(new EnvironmentVariablesNodeProperty.Entry(entry.getKey(), entry.getValue()));
        }
        localNodeProperties.add((Object)new EnvironmentVariablesNodeProperty(envVarEntries));
    }

    public static String encrypt(String message) {
        return useNativeInstance ? Secret.fromString((String)message).getEncryptedValue() : new StringBuffer(message).reverse().toString();
    }

    public static String decrypt(String encryptedMessage) {
        return useNativeInstance ? Secret.decrypt((String)encryptedMessage).getPlainText() : new StringBuffer(encryptedMessage).reverse().toString();
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean nonNull(Object object) {
        return object != null;
    }

    static class NoopSaveable
    implements Saveable {
        NoopSaveable() {
        }

        public void save() throws IOException {
        }
    }
}

