/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pollmailboxtrigger.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.CustomProperties;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.Logger;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.MailWrapperUtils;

public class MailReader
extends Logger.HasLogger {
    private String host;
    private String storeName = "imaps";
    private String username;
    private String password;
    private CustomProperties properties = new CustomProperties();
    private Folder currentFolder;
    private Store store;

    public MailReader(String host, String username, String password) throws MessagingException {
        this(host, username, password, "imaps", Logger.getDefault(), new CustomProperties());
    }

    public MailReader(String host, String username, String password, String storeName, Logger logger, CustomProperties properties) throws MessagingException {
        super(logger);
        this.host = host;
        this.storeName = storeName;
        this.username = username;
        this.password = password;
        this.properties = properties;
    }

    public MailReader connect() throws MessagingException {
        Session session = Session.getInstance((Properties)this.properties.getProperties(), null);
        session.setDebugOut(this.getLogger().getPrintStream());
        this.store = session.getStore(this.storeName);
        this.store.connect(this.host, this.username, this.password);
        this.getLogger().info("[Poll Mailbox Trigger] - Connected!");
        return this;
    }

    public MailWrapperUtils.FolderWrapper folder(String folderName) throws MessagingException {
        if (this.store == null) {
            throw new RuntimeException("Session is not connected!");
        }
        this.currentFolder = this.store.getFolder(folderName);
        return new MailWrapperUtils.FolderWrapper(this.getLogger(), this.currentFolder);
    }

    public List<String> getFolders() throws MessagingException {
        Folder[] folders = this.store.getDefaultFolder().list("*");
        ArrayList<String> folderNames = new ArrayList<String>();
        for (Folder folder : folders) {
            if ((folder.getType() & 1) == 0) continue;
            folderNames.add(folder.getFullName());
        }
        return folderNames;
    }

    public void close() {
        if (this.currentFolder != null && this.currentFolder.isOpen()) {
            try {
                this.currentFolder.close(true);
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (MessagingException e) {
                e.printStackTrace();
            }
        }
    }
}

