/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pollmailboxtrigger.mail.utils;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pollmailboxtrigger.SafeJenkins;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.Stringify;

public class CustomProperties {
    private Map<String, String> delegate = new HashMap<String, String>();

    public CustomProperties() {
    }

    public CustomProperties(Properties properties1) {
        this.putAll(properties1);
    }

    public CustomProperties(Map<String, String> properties1) {
        this.putAll(properties1);
    }

    public CustomProperties(String properties) {
        this.putAll(properties);
    }

    public static CustomProperties read(String properties) {
        Properties p = new Properties();
        try {
            if (SafeJenkins.nonNull(properties) && !StringUtils.isBlank((String)properties.trim())) {
                p.load(new StringReader(properties));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new CustomProperties(p);
    }

    public void putAll(String properties) {
        this.putAll(CustomProperties.read(properties));
    }

    public void putAll(CustomProperties p2) {
        this.delegate.putAll(p2.getMap());
    }

    public void putAll(CustomProperties p2, String prefix) {
        this.putAll(p2.getMap(), prefix);
    }

    public void putAll(Properties p2) {
        this.putAll(p2, (String)null);
    }

    public void putAll(Properties p2, String prefix) {
        HashMap<String, String> tmp = new HashMap<String, String>();
        for (String key : p2.stringPropertyNames()) {
            tmp.put(key, p2.getProperty(key));
        }
        this.putAll(tmp, prefix);
    }

    public void putAll(Map<String, String> p2, String pPrefix) {
        String prefix = pPrefix;
        if (SafeJenkins.isNull(prefix)) {
            prefix = "";
        }
        for (Map.Entry<String, String> next : p2.entrySet()) {
            this.delegate.put(prefix + next.getKey(), next.getValue());
        }
    }

    public Properties getProperties() {
        Properties p = new Properties();
        for (Map.Entry<String, String> entry : this.delegate.entrySet()) {
            if (entry == null || entry.getKey() == null || entry.getValue() == null) continue;
            p.put(entry.getKey(), entry.getValue());
        }
        return p;
    }

    public Map<String, String> getMap() {
        return this.delegate;
    }

    public boolean has(String o) {
        return this.delegate.containsKey(o);
    }

    public boolean has(Enum o) {
        return this.has(o.name());
    }

    public String get(Enum o) {
        return this.get(o.name());
    }

    public CustomProperties put(Enum s, String s2) {
        this.put(s.name(), s2);
        return this;
    }

    public String remove(Enum o) {
        return this.remove(o.name());
    }

    public CustomProperties putIfBlank(Enum s, String s2) {
        return this.putIfBlank(s.name(), s2);
    }

    public CustomProperties putIfBlank(String s, String s2) {
        String existingValue = this.get(s);
        if (!this.has(s) || SafeJenkins.isNull(existingValue) || StringUtils.isBlank((String)existingValue)) {
            return this.put(s, s2);
        }
        return null;
    }

    public void removeBlanks() {
        ArrayList<String> removekeys = new ArrayList<String>();
        for (String key : this.delegate.keySet()) {
            String value = this.delegate.get(key);
            if (!StringUtils.isBlank((String)value)) continue;
            removekeys.add(key);
        }
        for (String removekey : removekeys) {
            this.delegate.remove(removekey);
        }
    }

    public String toString() {
        return Stringify.stringify(this.delegate);
    }

    public int size() {
        return this.delegate.size();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    public boolean containsKey(String o) {
        return this.delegate.containsKey(o);
    }

    public boolean containsValue(String o) {
        return this.delegate.containsValue(o);
    }

    public String get(String o) {
        return this.delegate.get(o);
    }

    public CustomProperties put(String s, String s2) {
        this.delegate.put(s, s2);
        return this;
    }

    public String remove(String o) {
        return this.delegate.remove(o);
    }

    public void putAll(Map<? extends String, ? extends String> map) {
        this.delegate.putAll(map);
    }

    public void clear() {
        this.delegate.clear();
    }

    public Set<String> keySet() {
        return this.delegate.keySet();
    }

    public Collection<String> values() {
        return this.delegate.values();
    }

    public Set<Map.Entry<String, String>> entrySet() {
        return this.delegate.entrySet();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CustomProperties)) {
            return false;
        }
        CustomProperties that = (CustomProperties)o;
        return this.delegate.equals(that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

