/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pollmailboxtrigger.mail.utils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.apache.commons.codec.Charsets;
import org.jenkinsci.lib.xtrigger.XTriggerLog;

public abstract class Logger {
    private static final Logger DEFAULT = new Logger(){

        @Override
        public void info(String message) {
            this.write(System.out, message);
        }

        @Override
        public void error(String message) {
            this.write(System.err, message);
        }

        private void write(PrintStream out, String message) {
            if (!"".equals(message.trim())) {
                out.print(message);
                if (!message.contains("\n")) {
                    out.print("\n");
                }
            }
        }
    };

    public static Logger getDefault() {
        return DEFAULT;
    }

    public abstract void info(String var1);

    public abstract void error(String var1);

    public OutputStream getOutputStream() {
        return new LoggerStream(this);
    }

    public PrintStream getPrintStream() {
        try {
            return new PrintStream((OutputStream)new LoggerStream(this), false, Charsets.UTF_8.displayName());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot handle UnsupportedEncodingException", e);
        }
    }

    public static class XTriggerLoggerWrapper
    extends Logger {
        private XTriggerLog delegate;

        public XTriggerLoggerWrapper(XTriggerLog delegate) {
            this.delegate = delegate;
        }

        @Override
        public void error(String message) {
            this.delegate.error(message);
        }

        @Override
        public void info(String message) {
            this.delegate.info(message);
        }
    }

    private static final class LoggerStream
    extends OutputStream {
        private final Logger logger;

        private LoggerStream(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.logger.info(new String(b, Charsets.UTF_8));
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.logger.info(new String(b, off, len, Charsets.UTF_8));
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b});
        }
    }

    public static abstract class HasLogger {
        private Logger logger;

        public HasLogger(Logger logger) {
            this.logger = logger;
        }

        public Logger getLogger() {
            return this.logger;
        }
    }
}

