/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pollmailboxtrigger.mail.utils;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.MimeBodyPart;
import javax.mail.search.SearchTerm;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.pollmailboxtrigger.PollMailboxTrigger;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.CustomProperties;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.Logger;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.SearchTermHelpers;
import org.jenkinsci.plugins.pollmailboxtrigger.mail.utils.Stringify;

public abstract class MailWrapperUtils {

    public static class FolderWrapper
    extends Logger.HasLogger {
        public static final SearchTerm UNREAD_FLAG = SearchTermHelpers.not(SearchTermHelpers.flag(Flags.Flag.SEEN));
        private Folder folder;

        public FolderWrapper(Logger logger, Folder folder) {
            super(logger);
            this.folder = folder;
        }

        public Folder getFolder() {
            return this.folder;
        }

        public MessagesWrapper getUnreadMessagesSince(Date fromDate) throws MessagingException {
            return this.search(UNREAD_FLAG, SearchTermHelpers.receivedSince(fromDate));
        }

        public MessagesWrapper getUnreadMessages() throws MessagingException {
            return this.search(UNREAD_FLAG);
        }

        public MessagesWrapper search(SearchTerm ... term) throws MessagingException {
            return this.search(Arrays.asList(term));
        }

        public MessagesWrapper search(List<SearchTerm> term) throws MessagingException {
            if (!this.folder.isOpen()) {
                this.folder.open(1);
            }
            Message[] messages = this.folder.search(SearchTermHelpers.and(term));
            return new MessagesWrapper(this.getLogger(), Arrays.asList(messages), this.folder);
        }

        public void close() throws MessagingException {
            this.folder.close(true);
        }
    }

    public static class MessagesWrapper
    extends Logger.HasLogger {
        private List<Message> messages;
        private Folder folder;

        public MessagesWrapper(Logger logger, List<Message> messages, Folder folder) {
            super(logger);
            this.messages = messages;
            this.folder = folder;
        }

        public List<Message> getMessages() {
            return this.messages;
        }

        public Folder getFolder() {
            return this.folder;
        }

        public MessagesWrapper print() throws MessagingException {
            this.getLogger().info("Found message(s) : " + this.messages.size());
            for (Message message : this.messages) {
                this.getLogger().info(">>>>>>");
                this.getLogger().info("Date    : " + message.getSentDate());
                this.getLogger().info("From    : " + (message.getFrom().length > 0 ? message.getFrom()[0] : null));
                this.getLogger().info("Subject : " + message.getSubject());
                this.getLogger().info("<<<<<<");
            }
            return this;
        }

        public MessagesWrapper markAsRead(Message ... messagez) throws IOException, MessagingException {
            return this.markAsRead(Arrays.asList(messagez));
        }

        public MessagesWrapper markAsRead(List<Message> messagez) throws IOException, MessagingException {
            if (this.folder.isOpen() && this.folder.getMode() != 2) {
                this.folder.close(true);
            }
            if (!this.folder.isOpen()) {
                this.folder.open(2);
            }
            for (Message message : messagez) {
                message.setFlag(Flags.Flag.SEEN, true);
            }
            this.getLogger().info("Marked email(s) as read : " + messagez.size());
            return this;
        }

        public MessagesWrapper markAsRead() throws IOException, MessagingException {
            return this.markAsRead(this.messages);
        }

        public CustomProperties getMessageProperties(Message message, String prefix, CustomProperties p) throws MessagingException, IOException {
            CustomProperties envVars = new CustomProperties();
            String msgSubject = Stringify.stringify(message.getSubject());
            envVars.put(prefix + "subject", msgSubject);
            envVars.put(prefix + "from", Stringify.stringify(message.getFrom()));
            envVars.put(prefix + "replyTo", Stringify.stringify(message.getReplyTo()));
            envVars.put(prefix + "flags", Stringify.stringify(message.getFlags()));
            envVars.put(prefix + "folder", Stringify.stringify(message.getFolder()));
            envVars.put(prefix + "messageNumber", Stringify.stringify(message.getMessageNumber()));
            envVars.put(prefix + "receivedDate", Stringify.stringify(message.getReceivedDate()));
            envVars.put(prefix + "sentDate", Stringify.stringify(message.getSentDate()));
            envVars.put(prefix + "headers", Stringify.stringify(message.getAllHeaders()));
            envVars.put(prefix + "content", Stringify.stringify((Part)message));
            envVars.put(prefix + "contentType", Stringify.stringify(message.getContentType()));
            envVars.put(prefix + "recipients", Stringify.stringify(message.getAllRecipients()));
            CustomProperties properties = CustomProperties.read(MessagesWrapper.getText((Part)message));
            envVars.putAll(properties);
            if (p.has(PollMailboxTrigger.Properties.subjectContains)) {
                String subject = p.get(PollMailboxTrigger.Properties.subjectContains);
                int idx = msgSubject.toLowerCase().indexOf(subject.toLowerCase());
                int beginIndex = idx + subject.length();
                if (idx > -1 && beginIndex < msgSubject.length()) {
                    envVars.put(prefix + "jobTrigger", msgSubject.substring(beginIndex).trim());
                }
            }
            return envVars;
        }

        public static String getText(Part p) {
            try {
                String text = Stringify.stringify(p);
                text = Stringify.stringify(text.split("(?i)</?br[^>]*>|</?p[^>]*>|</?div[^>]*>"), "\n");
                text = Stringify.stringify(text.split("<[^>]*>"), "");
                List<String> content = MessagesWrapper.filterProperties(text.split("\n"), "=");
                text = Stringify.stringify(content, "\n");
                return text;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public static List<String> filterProperties(String[] props, String containing) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(props));
            Iterator<String> it = list.iterator();
            while (it.hasNext()) {
                String foo = it.next();
                if (foo.contains(containing)) continue;
                it.remove();
            }
            return list;
        }

        public File saveAttachments(Message message) throws IOException, MessagingException {
            File tmpDir = Files.createTempDir();
            boolean foundAttachments = false;
            Object content = message.getContent();
            if (message.isMimeType("multipart/*") && content instanceof Multipart) {
                Multipart mp = (Multipart)content;
                for (int i = 0; i < mp.getCount(); ++i) {
                    BodyPart bodyPart = mp.getBodyPart(i);
                    if (!(bodyPart instanceof MimeBodyPart) || !StringUtils.isNotBlank((String)bodyPart.getFileName())) continue;
                    MimeBodyPart mimeBodyPart = (MimeBodyPart)bodyPart;
                    mimeBodyPart.saveFile(new File(tmpDir, mimeBodyPart.getFileName()));
                    foundAttachments = true;
                }
            }
            return foundAttachments ? tmpDir : null;
        }

        public void close() throws MessagingException {
            this.folder.close(true);
        }
    }
}

