/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pollmailboxtrigger.mail.utils;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.mail.Flags;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.FromStringTerm;
import javax.mail.search.NotTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SubjectTerm;

public final class SearchTermHelpers {
    private SearchTermHelpers() {
    }

    public static SearchTerm and(SearchTerm ... terms) {
        return new AndTerm(terms);
    }

    public static SearchTerm and(List<SearchTerm> terms) {
        return new AndTerm(terms.toArray(new SearchTerm[terms.size()]));
    }

    public static SearchTerm not(SearchTerm term) {
        return new NotTerm(term);
    }

    public static SearchTerm subject(String containsCaseInsensitive) {
        return new SubjectTerm(containsCaseInsensitive);
    }

    public static SearchTerm from(String email) {
        return new FromStringTerm(email);
    }

    public static SearchTerm receivedSince(Date date) {
        return new ReceivedDateTerm(5, date);
    }

    public static SearchTerm flag(Flags.Flag flag) {
        return new FlagTerm(new Flags(flag), true);
    }

    public static Date relativeDate(int unit, int amount) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.add(unit, amount);
        return calendar.getTime();
    }
}

