/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pollmailboxtrigger.mail.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang.StringUtils;

public abstract class Stringify {
    public static final String DATE_FORMAT_TEXT = "yyyy-MM-dd'T'HH:mm'Z'";
    public static final String TEXT_WILDCARD = "text/*";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String MULTIPART_WILDCARD = "multipart/*";
    public static final String MULTIPART_ALTERNATIVE = "multipart/alternative";
    public static final String NEWLINE = "\n";
    public static final String BLANK = "";

    public static String stringify(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static String stringify(String message) {
        return message;
    }

    public static <A> String stringify(A[] array) {
        return Stringify.stringify(array, null);
    }

    public static <A> String stringify(A[] array, String delimiter) {
        return Stringify.stringify(Arrays.asList(array), delimiter);
    }

    public static String stringify(List list) {
        return Stringify.stringify(list.iterator(), null);
    }

    public static String stringify(List list, String delimiter) {
        return Stringify.stringify(list.iterator(), delimiter);
    }

    public static String stringify(Set list) {
        return Stringify.stringify(list.iterator(), null);
    }

    public static String stringify(Set list, String delimiter) {
        return Stringify.stringify(list.iterator(), delimiter);
    }

    public static String stringify(Iterator iterator, String pDelimiter) {
        String delimiter = pDelimiter;
        if (delimiter == null) {
            delimiter = ", ";
        }
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            try {
                sb.append(Stringify.stringify(iterator.next()));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!iterator.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String stringify(Iterator<? extends Map.Entry<?, ?>> iterator, String pKeyValueDelimiter, String pDelimiter) {
        String keyValueDelimiter = pKeyValueDelimiter;
        String delimiter = pDelimiter;
        if (keyValueDelimiter == null) {
            keyValueDelimiter = "=";
        }
        if (delimiter == null) {
            delimiter = ", ";
        }
        StringBuilder sb = new StringBuilder();
        while (iterator.hasNext()) {
            try {
                sb.append(Stringify.stringify(iterator.next(), keyValueDelimiter));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (!iterator.hasNext()) continue;
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static String stringify(Date date) {
        if (date == null) {
            return "null";
        }
        return new SimpleDateFormat(DATE_FORMAT_TEXT).format(date);
    }

    public static String stringify(int messageNumber) {
        return String.valueOf(messageNumber);
    }

    public static String stringify(Enumeration allHeaders) {
        if (allHeaders == null) {
            return "null";
        }
        ArrayList list = new ArrayList();
        while (allHeaders.hasMoreElements()) {
            list.add(allHeaders.nextElement());
        }
        return Stringify.stringify(list);
    }

    public static String stringify(Map content) {
        return Stringify.stringify(content, null, null);
    }

    public static String stringify(Map<?, ?> content, String keyValueDelimiter, String delimiter) {
        Set<Map.Entry<?, ?>> entries = content.entrySet();
        Iterator<Map.Entry<?, ?>> iterator = entries.iterator();
        return Stringify.stringify(iterator, keyValueDelimiter, delimiter);
    }

    public static String stringify(Map.Entry content, String keyValueDelimiter) {
        return content.getKey() + keyValueDelimiter + content.getValue();
    }

    public static String stringify(Object content) {
        if (content instanceof Header) {
            return Stringify.stringify((Header)content);
        }
        if (content instanceof Part) {
            return Stringify.stringify((Part)content);
        }
        if (content instanceof Map) {
            return Stringify.stringify((Map)content);
        }
        if (content instanceof Flags.Flag) {
            return Stringify.stringify((Flags.Flag)content);
        }
        return content == null ? "null" : content.toString();
    }

    public static String stringify(Header content) {
        return content.getName() + "=" + content.getValue();
    }

    public static String stringify(Address[] addresses) {
        if (addresses != null) {
            ArrayList<String> parsed = new ArrayList<String>();
            for (Address addr : addresses) {
                if (addr instanceof InternetAddress) {
                    parsed.add(((InternetAddress)addr).getAddress());
                    continue;
                }
                parsed.add(addr.toString());
            }
            return StringUtils.join(parsed, (String)",");
        }
        return BLANK;
    }

    public static String stringify(Part part) {
        try {
            return Stringify.stringify(new StringBuilder(), part);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String stringify(StringBuilder builder, Part part) throws MessagingException, IOException {
        Object content = part.getContent();
        if (content == null) {
            return "null";
        }
        if (part.isMimeType(TEXT_WILDCARD) && content instanceof String) {
            builder.append(NEWLINE + content);
        }
        if (part.isMimeType(MULTIPART_WILDCARD) && content instanceof Multipart) {
            Multipart mp = (Multipart)content;
            for (int i = mp.getCount() - 1; i >= 0; --i) {
                Stringify.stringify(builder, (Part)mp.getBodyPart(i));
            }
        }
        return builder.toString();
    }

    public static String stringify(Flags flags) {
        if (flags == null) {
            return "null";
        }
        ArrayList<Object> tmp = new ArrayList<Object>();
        tmp.addAll(Arrays.asList(flags.getSystemFlags()));
        tmp.addAll(Arrays.asList(flags.getUserFlags()));
        return Stringify.stringify(tmp);
    }

    public static String stringify(Flags.Flag flag) {
        if (flag == Flags.Flag.SEEN) {
            return "SEEN";
        }
        if (flag == Flags.Flag.ANSWERED) {
            return "ANSWERED";
        }
        if (flag == Flags.Flag.DELETED) {
            return "DELETED";
        }
        if (flag == Flags.Flag.DRAFT) {
            return "DRAFT";
        }
        if (flag == Flags.Flag.FLAGGED) {
            return "FLAGGED";
        }
        if (flag == Flags.Flag.RECENT) {
            return "RECENT";
        }
        if (flag == Flags.Flag.USER) {
            return "USER";
        }
        return BLANK;
    }

    public static String stringify(Folder folder) {
        if (folder == null) {
            return "null";
        }
        return folder.getFullName();
    }
}

