/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scripttrigger;

import antlr.ANTLRException;
import hudson.Util;
import hudson.model.Action;
import hudson.model.BuildableItem;
import hudson.model.Node;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.lib.xtrigger.AbstractTrigger;
import org.jenkinsci.lib.xtrigger.XTriggerLog;
import org.jenkinsci.plugins.pollmailboxtrigger.PollMailboxTriggerRunAction;

public abstract class AbstractTriggerExt
extends AbstractTrigger {
    private boolean labelRestriction;
    private boolean enableConcurrentBuild;

    public AbstractTriggerExt(String cronTabSpec, boolean labelRestriction, String triggerLabel, boolean enableConcurrentBuild) throws ANTLRException {
        super(cronTabSpec, triggerLabel, enableConcurrentBuild);
        this.labelRestriction = labelRestriction;
        this.enableConcurrentBuild = enableConcurrentBuild;
    }

    public boolean isEnableConcurrentBuild() {
        return this.enableConcurrentBuild;
    }

    public boolean isLabelRestriction() {
        return this.labelRestriction;
    }

    protected void start(Node pollingNode, BuildableItem project, boolean newInstance, XTriggerLog log) {
    }

    protected String getName() {
        return "ScriptTrigger";
    }

    protected String getCause() {
        try {
            String scriptContent = Util.loadFile((File)this.getLogFile());
            String cause = this.extractRootCause(scriptContent);
            if (cause == null) {
                return this.getDefaultMessageCause();
            }
            return cause;
        }
        catch (IOException e) {
            return this.getDefaultMessageCause();
        }
    }

    protected abstract String getDefaultMessageCause();

    private String extractRootCause(String content) {
        return StringUtils.substringBetween((String)content, (String)"<cause>", (String)"</cause>");
    }

    protected Action[] getScheduledActions(Node pollingNode, XTriggerLog log) {
        String scriptContent;
        try {
            scriptContent = Util.loadFile((File)this.getLogFile());
        }
        catch (IOException e) {
            return new Action[0];
        }
        ArrayList<PollMailboxTriggerRunAction> actionList = new ArrayList<PollMailboxTriggerRunAction>();
        String description = this.extractDescription(scriptContent);
        if (description != null) {
            actionList.add(new PollMailboxTriggerRunAction(description));
        }
        return actionList.toArray(new Action[actionList.size()]);
    }

    private String extractDescription(String content) {
        return StringUtils.substringBetween((String)content, (String)"<description>", (String)"</description>");
    }

    protected boolean requiresWorkspaceForPolling() {
        return false;
    }
}

