/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.model.Cause;
import hudson.security.ACL;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.http.HttpServletRequest;
import jenkins.scm.api.SCMEventListener;
import jenkins.util.Timer;
import org.acegisecurity.Authentication;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;

public abstract class SCMEvent<P> {
    private static final Cause[] EMPTY_CAUSES = new Cause[0];
    public static final String ORIGIN_UNKNOWN = "?";
    @NonNull
    private final Type type;
    private final long timestamp;
    @NonNull
    private final P payload;
    @CheckForNull
    private final String origin;

    @Deprecated
    public SCMEvent(@NonNull Type type, long timestamp, @NonNull P payload) {
        this(type, timestamp, payload, SCMEvent.originOf((HttpServletRequest)Stapler.getCurrentRequest()));
    }

    public SCMEvent(@NonNull Type type, long timestamp, @NonNull P payload, @CheckForNull String origin) {
        this.type = type;
        this.timestamp = timestamp;
        this.payload = payload;
        this.origin = ORIGIN_UNKNOWN.equals(origin) ? null : origin;
    }

    @Deprecated
    public SCMEvent(@NonNull Type type, @NonNull P payload) {
        this(type, System.currentTimeMillis(), payload);
    }

    public SCMEvent(@NonNull Type type, @NonNull P payload, @CheckForNull String origin) {
        this(type, System.currentTimeMillis(), payload, origin);
    }

    protected SCMEvent(SCMEvent<P> copy) {
        this(copy.getType(), copy.getTimestamp(), copy.getPayload(), copy.origin);
    }

    @NonNull
    protected static ScheduledExecutorService executorService() {
        return Timer.get();
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @NonNull
    public Date getDate() {
        return new Date(this.timestamp);
    }

    @NonNull
    public P getPayload() {
        return this.payload;
    }

    @NonNull
    public String getOrigin() {
        return StringUtils.defaultIfBlank((String)this.origin, (String)ORIGIN_UNKNOWN);
    }

    @NonNull
    public Cause[] asCauses() {
        return EMPTY_CAUSES;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SCMEvent scmEvent = (SCMEvent)o;
        if (this.type != scmEvent.type) {
            return false;
        }
        if (this.timestamp != scmEvent.timestamp) {
            return false;
        }
        return this.payload.equals(scmEvent.payload);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.payload.hashCode();
        return result;
    }

    public String toString() {
        return String.format("SCMEvent{type=%s, timestamp=%tc, payload=%s, origin=%s}", new Object[]{this.type, this.timestamp, this.payload, StringUtils.defaultIfBlank((String)this.origin, (String)ORIGIN_UNKNOWN)});
    }

    @CheckForNull
    public static String originOf(@CheckForNull HttpServletRequest req) {
        int port;
        if (req == null) {
            return null;
        }
        String last = null;
        StringBuilder result = new StringBuilder();
        String header = req.getHeader("X-Forwarded-For");
        if (StringUtils.isNotBlank((String)header)) {
            for (String remote : header.split("(,\\s*)")) {
                if (StringUtils.isBlank((String)remote)) continue;
                if (last != null) {
                    result.append(" \u2192 ");
                }
                last = StringUtils.trim((String)remote);
                result.append(last);
            }
        }
        String remoteHost = req.getRemoteHost();
        String remoteAddr = req.getRemoteAddr();
        if (last == null || !StringUtils.equals(last, (String)remoteHost) && !StringUtils.equals(last, (String)remoteAddr)) {
            if (last != null) {
                result.append(" \u2192 ");
            }
            if (!StringUtils.isBlank((String)remoteHost) && !remoteHost.equals(remoteAddr)) {
                result.append(remoteHost);
                result.append('/');
            }
            result.append(remoteAddr);
        }
        result.append(" \u21d2 ");
        String scheme = StringUtils.defaultIfBlank((String)req.getHeader("X-Forwarded-Proto"), (String)req.getScheme());
        result.append(scheme);
        result.append("://");
        result.append(req.getServerName());
        String portStr = req.getHeader("X-Forwarded-Port");
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                port = req.getRemotePort();
            }
        } else {
            port = req.getRemotePort();
        }
        if (!("http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443)) {
            result.append(':');
            result.append(port);
        }
        result.append(req.getRequestURI());
        return result.toString();
    }

    protected static abstract class Dispatcher<E extends SCMEvent<?>>
    implements Runnable {
        @Restricted(value={NoExternalUse.class})
        static final AtomicLong lastId = new AtomicLong();
        @Restricted(value={NoExternalUse.class})
        static final Lock lock = new ReentrantLock();
        @Restricted(value={NoExternalUse.class})
        static final Condition started = lock.newCondition();
        @Restricted(value={NoExternalUse.class})
        static final Condition finished = lock.newCondition();
        @Restricted(value={NoExternalUse.class})
        static long startedId = 0L;
        @Restricted(value={NoExternalUse.class})
        static long finishedId = 0L;
        @Restricted(value={NoExternalUse.class})
        static int inFlight = 0;
        private final long id;
        private final E event;

        public Dispatcher(E event) {
            this.event = event;
            this.id = lastId.incrementAndGet();
        }

        protected abstract void log(SCMEventListener var1, Throwable var2);

        protected abstract void fire(SCMEventListener var1, E var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            lock.lock();
            try {
                if (startedId < this.id) {
                    startedId = this.id;
                    started.signalAll();
                }
                ++inFlight;
            }
            finally {
                lock.unlock();
            }
            String oldName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(String.format("%s %tc / %s", this.event.getClass(), ((SCMEvent)this.event).getTimestamp(), oldName));
                for (SCMEventListener l : ExtensionList.lookup(SCMEventListener.class)) {
                    SecurityContext context = ACL.impersonate((Authentication)ACL.SYSTEM);
                    try {
                        this.fire(l, this.event);
                    }
                    catch (LinkageError e) {
                        this.log(l, e);
                    }
                    catch (Error e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        this.log(l, e);
                    }
                    finally {
                        SecurityContextHolder.setContext((SecurityContext)context);
                    }
                }
            }
            finally {
                Thread.currentThread().setName(oldName);
                lock.lock();
                try {
                    if (finishedId < this.id) {
                        finishedId = this.id;
                    }
                    if (--inFlight <= 0) {
                        inFlight = 0;
                        finished.signalAll();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }

    public static enum Type {
        CREATED,
        UPDATED,
        REMOVED;

    }
}

