/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl;

import hudson.model.AbstractProject;
import hudson.model.Descriptor;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.plugins.git.GitSCM;
import hudson.scm.NullSCM;
import hudson.scm.SCM;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import java.util.Map;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.impl.SingleSCMSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TestExtension;
import org.kohsuke.stapler.DataBoundConstructor;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class SingleSCMSourceTest {
    @ClassRule
    public static JenkinsRule r = new JenkinsRule();

    @Test
    public void configRoundtrip() throws Exception {
        SingleSCMSource source = new SingleSCMSource("the-id", "the-name", (SCM)new GitSCM("https://nowhere.net/something.git"));
        SCMSourceBuilder builder = new SCMSourceBuilder((SCMSource)source);
        r.assertEqualDataBoundBeans((Object)builder, (Object)r.configRoundtrip((Builder)builder));
    }

    @Test
    public void given_instance_when_fetch_then_revisionObserved() throws Exception {
        SCMHeadObserver observer = (SCMHeadObserver)Mockito.mock(SCMHeadObserver.class);
        SingleSCMSource instance = new SingleSCMSource("the-id", "the-name", (SCM)new GitSCM("https://nowhere.net/something.git"));
        instance.fetch(null, observer, null);
        ((SCMHeadObserver)Mockito.verify((Object)observer)).observe((SCMHead)Mockito.argThat((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(SCMHead.class), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"the-name")))), (SCMRevision)Mockito.argThat((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(SCMRevision.class), (Matcher)Matchers.hasProperty((String)"head", (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"the-name"))), (Matcher)Matchers.hasProperty((String)"deterministic", (Matcher)Matchers.is((Object)false)))));
    }

    @Test
    public void given_instance_when_fetchWithCriterial_then_criteriaIgnoredAndRevisionObserved() throws Exception {
        SCMHeadObserver observer = (SCMHeadObserver)Mockito.mock(SCMHeadObserver.class);
        SCMSourceCriteria criteria = (SCMSourceCriteria)Mockito.mock(SCMSourceCriteria.class);
        InOrder seq = Mockito.inOrder((Object[])new Object[]{observer, criteria});
        SingleSCMSource instance = new SingleSCMSource("the-id", "the-name", (SCM)new GitSCM("https://nowhere.net/something.git"));
        instance.fetch(criteria, observer, null);
        ((SCMHeadObserver)seq.verify((Object)observer)).observe((SCMHead)Mockito.argThat((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(SCMHead.class), (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"the-name")))), (SCMRevision)Mockito.argThat((Matcher)Matchers.allOf((Matcher)Matchers.instanceOf(SCMRevision.class), (Matcher)Matchers.hasProperty((String)"head", (Matcher)Matchers.hasProperty((String)"name", (Matcher)Matchers.is((Object)"the-name"))), (Matcher)Matchers.hasProperty((String)"deterministic", (Matcher)Matchers.is((Object)false)))));
        seq.verifyNoMoreInteractions();
    }

    @Test
    public void given_instance_when_fetchingObservedHead_then_scmReturned() throws Exception {
        SingleSCMSource instance = new SingleSCMSource("the-id", "the-name", (SCM)new GitSCM("https://nowhere.net/something.git"));
        Map result = ((SCMHeadObserver.Collector)instance.fetch((SCMHeadObserver)SCMHeadObserver.collect(), null)).result();
        Assert.assertThat(result.entrySet(), (Matcher)Matchers.hasSize((int)1));
        Map.Entry entry = result.entrySet().iterator().next();
        Assert.assertThat((Object)instance.build((SCMHead)entry.getKey(), (SCMRevision)entry.getValue()), (Matcher)Matchers.instanceOf(GitSCM.class));
    }

    @Test
    public void given_instance_when_fetchingNonObservedHead_then_nullScmReturned() throws Exception {
        SingleSCMSource instance = new SingleSCMSource("the-id", "the-name", (SCM)new GitSCM("https://nowhere.net/something.git"));
        Assert.assertThat((Object)instance.build(new SCMHead("foo"), (SCMRevision)Mockito.mock(SCMRevision.class)), (Matcher)Matchers.instanceOf(NullSCM.class));
    }

    @Test
    public void scmRevisionImpl() throws Exception {
        SingleSCMSource instance = new SingleSCMSource("the-id", "the-name", (SCM)new GitSCM("https://nowhere.net/something.git"));
        Map result = ((SCMHeadObserver.Collector)instance.fetch((SCMHeadObserver)SCMHeadObserver.collect(), null)).result();
        SCMRevision revision = (SCMRevision)result.values().iterator().next();
        Assert.assertThat((Object)revision.isDeterministic(), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)revision.equals((Object)revision), (Matcher)Matchers.is((Object)true));
        Assert.assertThat((Object)revision.equals(Mockito.mock(SCMRevision.class)), (Matcher)Matchers.is((Object)false));
        Assert.assertThat((Object)revision.hashCode(), (Matcher)Matchers.is((Object)((SCMHead)result.keySet().iterator().next()).hashCode()));
    }

    @Test
    public void getSCMDescriptors() throws Exception {
        TopLevelItemDescriptor descriptor = (TopLevelItemDescriptor)Mockito.mock(TopLevelItemDescriptor.class);
        TopLevelSCMOwner owner = (TopLevelSCMOwner)Mockito.mock(TopLevelSCMOwner.class);
        Mockito.when((Object)owner.getDescriptor()).thenReturn((Object)descriptor);
        Mockito.when((Object)descriptor.isApplicable((Descriptor)org.mockito.Matchers.any(Descriptor.class))).thenReturn((Object)true);
        Assert.assertThat((Object)SingleSCMSource.DescriptorImpl.getSCMDescriptors((SCMSourceOwner)owner), (Matcher)Matchers.hasItem((Matcher)Matchers.instanceOf(GitSCM.DescriptorImpl.class)));
    }

    public static class SCMSourceBuilder
    extends Builder {
        public final SCMSource scm;

        @DataBoundConstructor
        public SCMSourceBuilder(SCMSource scm) {
            this.scm = scm;
        }

        @TestExtension
        public static class DescriptorImpl
        extends BuildStepDescriptor<Builder> {
            public String getDisplayName() {
                return "SCMSourceBuilder";
            }

            public boolean isApplicable(Class<? extends AbstractProject> jobType) {
                return true;
            }
        }
    }

    public static interface TopLevelSCMOwner
    extends TopLevelItem,
    SCMSourceOwner {
    }
}

