/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Action;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.scm.ChangeLogParser;
import hudson.scm.ChangeLogSet;
import hudson.scm.PollingResult;
import hudson.scm.RepositoryBrowser;
import hudson.scm.SCMDescriptor;
import hudson.scm.SCMRevisionState;
import hudson.util.ListBoxModel;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jenkins.scm.api.SCM2;
import jenkins.scm.api.SCMHead;
import jenkins.scm.impl.mock.MockChangeRequestSCMHead;
import jenkins.scm.impl.mock.MockSCMChangeLogSet;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMHead;
import jenkins.scm.impl.mock.MockSCMRepositoryBrowser;
import jenkins.scm.impl.mock.MockSCMRevision;
import jenkins.scm.impl.mock.MockSCMSource;
import jenkins.scm.impl.mock.MockTagSCMHead;
import org.apache.commons.io.IOUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.xml.sax.SAXException;

public class MockSCM
extends SCM2
implements Serializable {
    private final String controllerId;
    private final String repository;
    private final SCMHead head;
    private final MockSCMRevision revision;
    private transient MockSCMController controller;

    @DataBoundConstructor
    public MockSCM(String controllerId, String repository, String head, String revision) {
        this.controllerId = controllerId;
        this.repository = repository;
        Matcher m = Pattern.compile("CR-(\\d+)").matcher(head);
        if (m.matches()) {
            int number = Integer.parseInt(m.group(1));
            String target = null;
            try {
                target = this.controller().getTarget(repository, number);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.head = new MockChangeRequestSCMHead(number, target);
        } else if (head.startsWith("TAG:")) {
            long timestamp = 0L;
            try {
                timestamp = this.controller().getTagTimestamp(repository, head.substring(4));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.head = new MockTagSCMHead(head.substring(4), timestamp);
        } else {
            this.head = new MockSCMHead(head);
        }
        this.revision = revision == null ? null : new MockSCMRevision(this.head, revision);
    }

    public MockSCM(MockSCMSource config, SCMHead head, MockSCMRevision revision) {
        this.controllerId = config.getControllerId();
        this.repository = config.getRepository();
        this.head = head;
        this.revision = revision;
    }

    public MockSCM(MockSCMController controller, String repository, SCMHead head, MockSCMRevision revision) {
        this.controllerId = controller.getId();
        this.controller = controller;
        this.repository = repository;
        this.revision = revision;
        this.head = head;
    }

    public String getControllerId() {
        return this.controllerId;
    }

    private MockSCMController controller() {
        if (this.controller == null) {
            this.controller = MockSCMController.lookup(this.controllerId);
        }
        return this.controller;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getHead() {
        if (this.head instanceof MockChangeRequestSCMHead) {
            return "CR-" + ((MockChangeRequestSCMHead)this.head).getNumber();
        }
        if (this.head instanceof MockTagSCMHead) {
            return "TAG:" + this.head.getName();
        }
        return this.head.getName();
    }

    public String getRevision() {
        return this.revision == null ? null : this.revision.getHash();
    }

    public boolean supportsPolling() {
        return true;
    }

    public boolean requiresWorkspaceForPolling() {
        return false;
    }

    public PollingResult compareRemoteRevisionWith(@Nonnull Job<?, ?> project, @Nullable Launcher launcher, @Nullable FilePath workspace, @Nonnull TaskListener listener, @Nonnull SCMRevisionState baseline) throws IOException, InterruptedException {
        if (baseline instanceof MockSCMRevisionState) {
            String revision = this.revision == null ? (this.head instanceof MockChangeRequestSCMHead ? this.controller().getRevision(this.repository, "change-request/" + ((MockChangeRequestSCMHead)this.head).getNumber()) : this.controller().getRevision(this.repository, this.head.getName())) : this.revision.getHash();
            if (((MockSCMRevisionState)baseline).getRevision().getHash().equals(revision)) {
                return PollingResult.NO_CHANGES;
            }
            return PollingResult.SIGNIFICANT;
        }
        return PollingResult.BUILD_NOW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkout(@Nonnull Run<?, ?> build, @Nonnull Launcher launcher, @Nonnull FilePath workspace, @Nonnull TaskListener listener, @CheckForNull File changelogFile, @CheckForNull SCMRevisionState baseline) throws IOException, InterruptedException {
        String hash = this.controller().checkout(workspace, this.repository, this.revision == null ? this.head.getName() : this.revision.getHash());
        FileWriter writer = new FileWriter(changelogFile);
        try {
            Items.XSTREAM2.toXML(this.controller().log(this.repository, hash), (Writer)writer);
        }
        finally {
            IOUtils.closeQuietly((Writer)writer);
        }
        build.addAction((Action)new MockSCMRevisionState(new MockSCMRevision(this.head, hash)));
    }

    public SCMRevisionState calcRevisionsFromBuild(@Nonnull Run<?, ?> build, @Nullable FilePath workspace, @Nullable Launcher launcher, @Nonnull TaskListener listener) throws IOException, InterruptedException {
        return (SCMRevisionState)build.getAction(MockSCMRevisionState.class);
    }

    public ChangeLogParser createChangeLogParser() {
        return new ChangeLogParser(){

            public ChangeLogSet<? extends ChangeLogSet.Entry> parse(Run build, RepositoryBrowser<?> browser, File changelogFile) throws IOException, SAXException {
                List entries = (List)Items.XSTREAM2.fromXML(changelogFile);
                return new MockSCMChangeLogSet(build, browser, entries);
            }
        };
    }

    public String toString() {
        return "MockSCM{controllerId='" + this.controllerId + '\'' + ", repository='" + this.repository + '\'' + ", head=" + this.head + ", revision=" + (Object)((Object)this.revision) + '}';
    }

    @Extension
    public static class DescriptorImpl
    extends SCMDescriptor<MockSCM> {
        public DescriptorImpl() {
            super(MockSCMRepositoryBrowser.class);
        }

        public String getDisplayName() {
            return "Mock SCM";
        }

        public ListBoxModel doFillControllerIdItems() {
            ListBoxModel result = new ListBoxModel();
            for (MockSCMController c : MockSCMController.all()) {
                result.add(c.getId());
            }
            return result;
        }

        public ListBoxModel doFillRepositoryItems(@QueryParameter String controllerId) throws IOException {
            ListBoxModel result = new ListBoxModel();
            MockSCMController c = MockSCMController.lookup(controllerId);
            if (c != null) {
                for (String r : c.listRepositories()) {
                    result.add(r);
                }
            }
            return result;
        }

        public ListBoxModel doFillHeadItems(@QueryParameter String controllerId, @QueryParameter String repository) throws IOException {
            ListBoxModel result = new ListBoxModel();
            MockSCMController c = MockSCMController.lookup(controllerId);
            if (c != null) {
                for (String string : c.listBranches(repository)) {
                    result.add(string);
                }
                for (String string : c.listTags(repository)) {
                    result.add("TAG:" + string);
                }
                for (Integer n : c.listChangeRequests(repository)) {
                    result.add("CR-" + n);
                }
            }
            return result;
        }
    }

    public static class MockSCMRevisionState
    extends SCMRevisionState {
        private final MockSCMRevision revision;

        public MockSCMRevisionState(MockSCMRevision revision) {
            this.revision = revision;
        }

        public MockSCMRevision getRevision() {
            return this.revision;
        }
    }
}

