/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.scm.api.SCMNavigator;
import jenkins.scm.api.SCMNavigatorDescriptor;
import jenkins.scm.api.SCMNavigatorEvent;
import jenkins.scm.api.SCMNavigatorOwner;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceObserver;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.impl.mock.MockAvatarMetadataAction;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMLink;
import jenkins.scm.impl.mock.MockSCMSource;
import org.kohsuke.stapler.DataBoundConstructor;

public class MockSCMNavigator
extends SCMNavigator {
    private final String controllerId;
    private final boolean includeBranches;
    private final boolean includeTags;
    private final boolean includeChangeRequests;
    private transient MockSCMController controller;

    @DataBoundConstructor
    public MockSCMNavigator(String controllerId, boolean includeBranches, boolean includeTags, boolean includeChangeRequests) {
        this.controllerId = controllerId;
        this.includeBranches = includeBranches;
        this.includeTags = includeTags;
        this.includeChangeRequests = includeChangeRequests;
    }

    public MockSCMNavigator(MockSCMController controller, boolean includeBranches, boolean includeTags, boolean includeChangeRequests) {
        this.controllerId = controller.getId();
        this.controller = controller;
        this.includeBranches = includeBranches;
        this.includeTags = includeTags;
        this.includeChangeRequests = includeChangeRequests;
    }

    public String getControllerId() {
        return this.controllerId;
    }

    private MockSCMController controller() {
        if (this.controller == null) {
            this.controller = MockSCMController.lookup(this.controllerId);
        }
        return this.controller;
    }

    public boolean isIncludeBranches() {
        return this.includeBranches;
    }

    public boolean isIncludeTags() {
        return this.includeTags;
    }

    public boolean isIncludeChangeRequests() {
        return this.includeChangeRequests;
    }

    protected String id() {
        return this.controllerId;
    }

    public void visitSources(@NonNull SCMSourceObserver observer) throws IOException, InterruptedException {
        this.controller().applyLatency();
        this.controller().checkFaults(null, null, null, false);
        Set includes = observer.getIncludes();
        for (String name : this.controller().listRepositories()) {
            if (!observer.isObserving()) {
                return;
            }
            this.checkInterrupt();
            if (includes != null && !includes.contains(name)) continue;
            this.controller().applyLatency();
            this.controller().checkFaults(name, null, null, false);
            SCMSourceObserver.ProjectObserver po = observer.observe(name);
            po.addSource((SCMSource)new MockSCMSource(this.getId() + "::" + name, this.controller, name, this.includeBranches, this.includeTags, this.includeChangeRequests));
            po.complete();
        }
    }

    @NonNull
    public List<Action> retrieveActions(@NonNull SCMNavigatorOwner owner, @CheckForNull SCMNavigatorEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.controller().applyLatency();
        this.controller().checkFaults(null, null, null, true);
        ArrayList<Action> result = new ArrayList<Action>();
        result.add(new MockSCMLink("organization"));
        String description = this.controller().getDescription();
        String displayName = this.controller().getDisplayName();
        String url = this.controller().getUrl();
        String iconClassName = this.controller().getOrgIconClassName();
        if (description != null || displayName != null || url != null) {
            result.add((Action)new ObjectMetadataAction(displayName, description, url));
        }
        if (iconClassName != null) {
            result.add((Action)new MockAvatarMetadataAction(iconClassName));
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends SCMNavigatorDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "Mock SCM";
        }

        public SCMNavigator newInstance(@CheckForNull String name) {
            return null;
        }

        public ListBoxModel doFillControllerIdItems() {
            ListBoxModel result = new ListBoxModel();
            for (MockSCMController c : MockSCMController.all()) {
                result.add(c.getId());
            }
            return result;
        }
    }
}

