/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.mock.MockAvatarMetadataAction;
import jenkins.scm.impl.mock.MockChangeRequestSCMHead;
import jenkins.scm.impl.mock.MockSCM;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMHead;
import jenkins.scm.impl.mock.MockSCMLink;
import jenkins.scm.impl.mock.MockSCMRevision;
import jenkins.scm.impl.mock.MockTagSCMHead;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class MockSCMSource
extends SCMSource {
    private final String controllerId;
    private final String repository;
    private final boolean includeBranches;
    private final boolean includeTags;
    private final boolean includeChangeRequests;
    private transient MockSCMController controller;

    @DataBoundConstructor
    public MockSCMSource(@CheckForNull String id, String controllerId, String repository, boolean includeBranches, boolean includeTags, boolean includeChangeRequests) {
        super(id);
        this.controllerId = controllerId;
        this.repository = repository;
        this.includeBranches = includeBranches;
        this.includeTags = includeTags;
        this.includeChangeRequests = includeChangeRequests;
    }

    public MockSCMSource(String id, MockSCMController controller, String repository, boolean includeBranches, boolean includeTags, boolean includeChangeRequests) {
        super(id);
        this.controllerId = controller.getId();
        this.controller = controller;
        this.repository = repository;
        this.includeBranches = includeBranches;
        this.includeTags = includeTags;
        this.includeChangeRequests = includeChangeRequests;
    }

    public String getControllerId() {
        return this.controllerId;
    }

    private MockSCMController controller() {
        if (this.controller == null) {
            this.controller = MockSCMController.lookup(this.controllerId);
        }
        return this.controller;
    }

    public String getRepository() {
        return this.repository;
    }

    public boolean isIncludeBranches() {
        return this.includeBranches;
    }

    public boolean isIncludeTags() {
        return this.includeTags;
    }

    public boolean isIncludeChangeRequests() {
        return this.includeChangeRequests;
    }

    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        MockSCMHead head;
        String revision;
        this.controller().applyLatency();
        this.controller().checkFaults(this.repository, null, null, false);
        Set includes = observer.getIncludes();
        if (this.includeBranches) {
            for (String branch : this.controller().listBranches(this.repository)) {
                this.checkInterrupt();
                revision = this.controller().getRevision(this.repository, branch);
                head = new MockSCMHead(branch);
                if (includes != null && !includes.contains((Object)head)) continue;
                this.controller().applyLatency();
                this.controller().checkFaults(this.repository, head.getName(), null, false);
                if (criteria != null && !criteria.isHead((SCMSourceCriteria.Probe)new MockSCMProbe(head, revision), listener)) continue;
                this.controller().applyLatency();
                this.controller().checkFaults(this.repository, head.getName(), revision, false);
                observer.observe((SCMHead)head, (SCMRevision)new MockSCMRevision(head, revision));
            }
        }
        if (this.includeTags) {
            for (String tag : this.controller().listTags(this.repository)) {
                this.checkInterrupt();
                revision = this.controller().getRevision(this.repository, tag);
                head = new MockTagSCMHead(tag, this.controller().getTagTimestamp(this.repository, tag));
                if (includes != null && !includes.contains((Object)head)) continue;
                this.controller().applyLatency();
                this.controller().checkFaults(this.repository, head.getName(), null, false);
                if (criteria != null && !criteria.isHead((SCMSourceCriteria.Probe)new MockSCMProbe(head, revision), listener)) continue;
                this.controller().applyLatency();
                this.controller().checkFaults(this.repository, head.getName(), revision, false);
                observer.observe((SCMHead)head, (SCMRevision)new MockSCMRevision(head, revision));
            }
        }
        if (this.includeChangeRequests) {
            for (Integer number : this.controller().listChangeRequests(this.repository)) {
                this.checkInterrupt();
                revision = this.controller().getRevision(this.repository, "change-request/" + number);
                String target = this.controller().getTarget(this.repository, number);
                MockChangeRequestSCMHead head2 = new MockChangeRequestSCMHead(number, target);
                if (includes != null && !includes.contains((Object)head2)) continue;
                this.controller().applyLatency();
                this.controller().checkFaults(this.repository, head2.getName(), null, false);
                if (criteria != null && !criteria.isHead((SCMSourceCriteria.Probe)new MockSCMProbe(head2, revision), listener)) continue;
                this.controller().applyLatency();
                this.controller().checkFaults(this.repository, head2.getName(), revision, false);
                observer.observe((SCMHead)head2, (SCMRevision)new MockSCMRevision(head2, revision));
            }
        }
    }

    @NonNull
    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        return new MockSCM(this, head, revision instanceof MockSCMRevision ? (MockSCMRevision)revision : null);
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.controller().applyLatency();
        this.controller().checkFaults(this.repository, null, null, true);
        ArrayList<Action> result = new ArrayList<Action>();
        result.add(new MockSCMLink("source"));
        String description = this.controller().getDescription(this.repository);
        String displayName = this.controller().getDisplayName(this.repository);
        String url = this.controller().getUrl(this.repository);
        String iconClassName = this.controller().getRepoIconClassName();
        if (description != null || displayName != null || url != null) {
            result.add((Action)new ObjectMetadataAction(displayName, description, url));
        }
        if (iconClassName != null) {
            result.add((Action)new MockAvatarMetadataAction(iconClassName));
        }
        return result;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMRevision revision, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.controller().applyLatency();
        this.controller().checkFaults(this.repository, revision.getHead().getName(), ((MockSCMRevision)revision).getHash(), true);
        return Collections.singletonList(new MockSCMLink("revision"));
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.controller().applyLatency();
        this.controller().checkFaults(this.repository, head.getName(), null, true);
        ArrayList<Action> result = new ArrayList<Action>();
        if (head instanceof MockChangeRequestSCMHead) {
            result.add((Action)new ContributorMetadataAction("bob", "Bob Smith", "bob@example.com"));
            result.add((Action)new ObjectMetadataAction(String.format("Change request #%d", ((MockChangeRequestSCMHead)head).getNumber()), null, "http://changes.example.com/" + ((MockChangeRequestSCMHead)head).getId()));
        }
        result.add(new MockSCMLink("branch"));
        return result;
    }

    protected boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        if (category instanceof ChangeRequestSCMHeadCategory) {
            return this.includeChangeRequests;
        }
        if (category instanceof TagSCMHeadCategory) {
            return this.includeTags;
        }
        return true;
    }

    private class MockSCMProbe
    extends SCMProbe {
        private final String revision;
        private final SCMHead head;

        public MockSCMProbe(SCMHead head, String revision) {
            this.revision = revision;
            this.head = head;
        }

        @NonNull
        public SCMProbeStat stat(@NonNull String path) throws IOException {
            return SCMProbeStat.fromType((SCMFile.Type)MockSCMSource.this.controller().stat(MockSCMSource.this.repository, this.revision, path));
        }

        public void close() throws IOException {
        }

        public String name() {
            return this.head.getName();
        }

        public long lastModified() {
            return MockSCMSource.this.controller().lastModified(MockSCMSource.this.repository, this.revision);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "Mock SCM";
        }

        public ListBoxModel doFillControllerIdItems() {
            ListBoxModel result = new ListBoxModel();
            for (MockSCMController c : MockSCMController.all()) {
                result.add(c.getId());
            }
            return result;
        }

        public ListBoxModel doFillRepositoryItems(@QueryParameter String controllerId) throws IOException {
            ListBoxModel result = new ListBoxModel();
            MockSCMController c = MockSCMController.lookup(controllerId);
            if (c != null) {
                for (String r : c.listRepositories()) {
                    result.add(r);
                }
            }
            return result;
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, ChangeRequestSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT};
        }
    }
}

