/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api.metadata;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.model.InvisibleAction;
import java.io.Serializable;
import jenkins.model.Jenkins;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.lang.StringUtils;
import org.jenkins.ui.icon.Icon;
import org.jenkins.ui.icon.IconSet;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.ExportedBean;

@ExportedBean
public abstract class AvatarMetadataAction
extends InvisibleAction
implements Serializable {
    private static final long serialVersionUID = 1L;

    @CheckForNull
    public String getAvatarIconClassName() {
        return null;
    }

    @CheckForNull
    public String getAvatarDescription() {
        return null;
    }

    @CheckForNull
    public String getAvatarImageOf(@NonNull String size) {
        return this.avatarIconClassNameImageOf(this.getAvatarIconClassName(), size);
    }

    @CheckForNull
    protected final String avatarIconClassNameImageOf(@CheckForNull String iconClassName, @NonNull String size) {
        if (StringUtils.isNotBlank((String)iconClassName)) {
            Icon icon;
            String spec = null;
            if ("16x16".equals(size)) {
                spec = "icon-sm";
            } else if ("24x24".equals(size)) {
                spec = "icon-md";
            } else if ("32x32".equals(size)) {
                spec = "icon-lg";
            } else if ("48x48".equals(size)) {
                spec = "icon-xlg";
            }
            if (spec != null && (icon = IconSet.icons.getIconByClassSpec((Object)(iconClassName + " " + spec))) != null) {
                JellyContext ctx = new JellyContext();
                ctx.setVariable("resURL", (Object)(Stapler.getCurrentRequest().getContextPath() + Jenkins.RESOURCE_PATH));
                return icon.getQualifiedUrl(ctx);
            }
        }
        return null;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

