/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import hudson.model.Action;
import hudson.model.Actionable;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMRevisionAction;
import jenkins.scm.api.SCMSource;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMDiscoverBranches;
import jenkins.scm.impl.mock.MockSCMHead;
import jenkins.scm.impl.mock.MockSCMRevision;
import jenkins.scm.impl.mock.MockSCMSource;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class SCMRevisionActionTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void given__legacyData__when__gettingRevision__then__legacyReturned() throws Exception {
        MockSCMController c = MockSCMController.create();
        try {
            MockSCMSource source = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            MockSCMRevision revision = new MockSCMRevision(new MockSCMHead("head"), "hash");
            ActionableImpl a = new ActionableImpl();
            a.addAction((Action)new SCMRevisionAction((SCMRevision)revision, null));
            Assert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision)));
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void given__mixedData__when__gettingRevision__then__legacyReturnedForUnmatched() throws Exception {
        MockSCMController c = MockSCMController.create();
        try {
            MockSCMSource source1 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source1.setId("foo");
            MockSCMSource source2 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source2.setId("bar");
            MockSCMSource source3 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source3.setId("manchu");
            MockSCMRevision revision1 = new MockSCMRevision(new MockSCMHead("head1"), "hash1");
            MockSCMRevision revision2 = new MockSCMRevision(new MockSCMHead("head2"), "hash2");
            MockSCMRevision revision3 = new MockSCMRevision(new MockSCMHead("head3"), "hash3");
            ActionableImpl a = new ActionableImpl();
            a.addAction((Action)new SCMRevisionAction((SCMSource)source1, (SCMRevision)revision1));
            a.addAction((Action)new SCMRevisionAction((SCMRevision)revision2, null));
            a.addAction((Action)new SCMRevisionAction((SCMSource)source3, (SCMRevision)revision3));
            Assert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source1, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision1)));
            Assert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source2, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision2)));
            Assert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source3, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision3)));
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void given__mixedData__when__gettingRevision__then__firstlegacyReturnedForUnmatched() throws Exception {
        MockSCMController c = MockSCMController.create();
        try {
            MockSCMSource source1 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source1.setId("foo");
            MockSCMSource source2 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source2.setId("bar");
            MockSCMSource source3 = new MockSCMSource(c, "test", new MockSCMDiscoverBranches());
            source3.setId("manchu");
            MockSCMRevision revision1 = new MockSCMRevision(new MockSCMHead("head1"), "hash1");
            MockSCMRevision revision2 = new MockSCMRevision(new MockSCMHead("head2"), "hash2");
            MockSCMRevision revision3 = new MockSCMRevision(new MockSCMHead("head3"), "hash3");
            ActionableImpl a = new ActionableImpl();
            a.addAction((Action)new SCMRevisionAction((SCMSource)source1, (SCMRevision)revision1));
            a.addAction((Action)new SCMRevisionAction((SCMRevision)revision2, null));
            a.addAction((Action)new SCMRevisionAction((SCMRevision)revision3, null));
            Assert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source1, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision1)));
            Assert.assertThat((Object)SCMRevisionAction.getRevision((SCMSource)source2, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision2)));
            Assert.assertThat((String)"Cannot distinguish legacy", (Object)SCMRevisionAction.getRevision((SCMSource)source3, (Actionable)a), (Matcher)Matchers.is((Object)((Object)revision2)));
        }
        finally {
            c.close();
        }
    }

    private static class ActionableImpl
    extends Actionable {
        private ActionableImpl() {
        }

        public String getDisplayName() {
            return null;
        }

        public String getSearchUrl() {
            return null;
        }
    }
}

