/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import hudson.Launcher;
import hudson.model.TaskListener;
import hudson.triggers.SCMTrigger;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.util.Arrays;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.jvnet.hudson.test.JenkinsRule;

public abstract class AbstractSampleRepoRule
extends ExternalResource {
    protected final TemporaryFolder tmp = new TemporaryFolder();

    public static void run(boolean probing, File cwd, String ... cmds) throws Exception {
        try {
            StreamTaskListener listener = StreamTaskListener.fromStdout();
            int r = new Launcher.LocalLauncher((TaskListener)listener).launch().cmds(cmds).pwd(cwd).stdout((TaskListener)listener).join();
            String message = Arrays.toString(cmds) + " failed with error code";
            if (probing) {
                Assume.assumeThat((String)message, (Object)r, (Matcher)Matchers.is((Object)0));
            } else {
                Assert.assertThat((String)message, (Object)r, (Matcher)Matchers.is((Object)0));
            }
        }
        catch (Exception x) {
            if (probing) {
                Assume.assumeNoException((String)(Arrays.toString(cmds) + " failed with exception (required tooling not installed?)"), (Throwable)x);
            }
            throw x;
        }
    }

    protected AbstractSampleRepoRule() {
    }

    protected void before() throws Throwable {
        this.tmp.create();
    }

    protected void after() {
        this.tmp.delete();
    }

    protected final void synchronousPolling(JenkinsRule r) {
        ((SCMTrigger.DescriptorImpl)r.jenkins.getDescriptorByType(SCMTrigger.DescriptorImpl.class)).synchronousPolling = true;
    }
}

