/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMBuilder;
import jenkins.scm.api.trait.SCMSourceContext;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.mock.MockSCMBuilder;
import jenkins.scm.impl.mock.MockSCMSourceContext;
import org.codehaus.plexus.util.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;

public class MockSCMDiscoverChangeRequests
extends SCMSourceTrait {
    private final Set<ChangeRequestCheckoutStrategy> strategies;

    public MockSCMDiscoverChangeRequests(Collection<ChangeRequestCheckoutStrategy> strategies) {
        this.strategies = strategies.isEmpty() ? EnumSet.of(ChangeRequestCheckoutStrategy.HEAD) : EnumSet.copyOf(strategies);
    }

    public MockSCMDiscoverChangeRequests(ChangeRequestCheckoutStrategy ... strategies) {
        this(Arrays.asList(strategies));
    }

    @DataBoundConstructor
    public MockSCMDiscoverChangeRequests(String strategiesStr) {
        this(MockSCMDiscoverChangeRequests.fromString(strategiesStr));
    }

    private static Set<ChangeRequestCheckoutStrategy> fromString(String strategiesStr) {
        EnumSet<ChangeRequestCheckoutStrategy> strategies = EnumSet.noneOf(ChangeRequestCheckoutStrategy.class);
        for (String s : StringUtils.split((String)strategiesStr, (String)", ")) {
            try {
                strategies.add(ChangeRequestCheckoutStrategy.valueOf((String)s.trim()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return strategies;
    }

    public String getStrategiesStr() {
        StringBuilder r = new StringBuilder();
        for (ChangeRequestCheckoutStrategy s : this.strategies) {
            r.append(s.name()).append(", ");
        }
        return r.toString();
    }

    protected void decorateContext(SCMSourceContext<?, ?> context) {
        MockSCMSourceContext ctx = (MockSCMSourceContext)context;
        ctx.withChangeRequests(true);
        ctx.withCheckoutStrategies(this.strategies);
    }

    public boolean includeCategory(@NonNull SCMHeadCategory category) {
        return category instanceof ChangeRequestSCMHeadCategory;
    }

    @Symbol(value={"discoverChangeRequests"})
    @Extension
    public static final class DescriptorImpl
    extends SCMSourceTraitDescriptor {
        public String getDisplayName() {
            return "Discover change requests";
        }

        public boolean isApplicableToContext(@NonNull Class<? extends SCMSourceContext> contextClass) {
            return MockSCMSourceContext.class.isAssignableFrom(contextClass);
        }

        public boolean isApplicableToBuilder(@NonNull Class<? extends SCMBuilder> builderClass) {
            return MockSCMBuilder.class.isAssignableFrom(builderClass);
        }
    }
}

