/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.impl.mock;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.TaskListener;
import hudson.scm.SCM;
import hudson.util.ListBoxModel;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadCategory;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMProbe;
import jenkins.scm.api.SCMProbeStat;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.SCMSourceEvent;
import jenkins.scm.api.metadata.ContributorMetadataAction;
import jenkins.scm.api.metadata.ObjectMetadataAction;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.trait.SCMSourceRequest;
import jenkins.scm.api.trait.SCMSourceTrait;
import jenkins.scm.api.trait.SCMSourceTraitDescriptor;
import jenkins.scm.api.trait.SCMTrait;
import jenkins.scm.impl.ChangeRequestSCMHeadCategory;
import jenkins.scm.impl.TagSCMHeadCategory;
import jenkins.scm.impl.UncategorizedSCMHeadCategory;
import jenkins.scm.impl.mock.MockAvatarMetadataAction;
import jenkins.scm.impl.mock.MockChangeRequestFlags;
import jenkins.scm.impl.mock.MockChangeRequestSCMHead;
import jenkins.scm.impl.mock.MockChangeRequestSCMRevision;
import jenkins.scm.impl.mock.MockSCMBuilder;
import jenkins.scm.impl.mock.MockSCMController;
import jenkins.scm.impl.mock.MockSCMDiscoverBranches;
import jenkins.scm.impl.mock.MockSCMHead;
import jenkins.scm.impl.mock.MockSCMLink;
import jenkins.scm.impl.mock.MockSCMRevision;
import jenkins.scm.impl.mock.MockSCMSourceContext;
import jenkins.scm.impl.mock.MockSCMSourceRequest;
import jenkins.scm.impl.mock.MockTagSCMHead;
import org.apache.commons.io.IOUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class MockSCMSource
extends SCMSource {
    private final String controllerId;
    private final String repository;
    private final List<SCMSourceTrait> traits;
    private transient MockSCMController controller;

    @DataBoundConstructor
    public MockSCMSource(String controllerId, String repository, List<SCMSourceTrait> traits) {
        this.controllerId = controllerId;
        this.repository = repository;
        this.traits = SCMTrait.asSetList(traits);
    }

    public MockSCMSource(String controllerId, String repository, SCMSourceTrait ... traits) {
        this(controllerId, repository, Arrays.asList(traits));
    }

    public MockSCMSource(MockSCMController controller, String repository, List<SCMSourceTrait> traits) {
        this.controllerId = controller.getId();
        this.controller = controller;
        this.repository = repository;
        this.traits = SCMTrait.asSetList(traits);
    }

    public MockSCMSource(MockSCMController controller, String repository, SCMSourceTrait ... traits) {
        this(controller, repository, Arrays.asList(traits));
    }

    public String getControllerId() {
        return this.controllerId;
    }

    private MockSCMController controller() {
        if (this.controller == null) {
            this.controller = MockSCMController.lookup(this.controllerId);
        }
        return this.controller;
    }

    public List<SCMSourceTrait> getTraits() {
        return Collections.unmodifiableList(this.traits);
    }

    public String getRepository() {
        return this.repository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void retrieve(@CheckForNull SCMSourceCriteria criteria, @NonNull SCMHeadObserver observer, @CheckForNull SCMHeadEvent<?> event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        block12: {
            MockSCMSourceRequest request = ((MockSCMSourceContext)new MockSCMSourceContext(this, criteria, observer).withTraits(this.traits)).newRequest(this, listener);
            try {
                this.controller().applyLatency();
                this.controller().checkFaults(this.repository, null, null, false);
                if (request.isFetchBranches()) {
                    for (final String branch : this.controller().listBranches(this.repository)) {
                        if (!request.process(new MockSCMHead(branch), (SCMSourceRequest.RevisionLambda)new SCMSourceRequest.RevisionLambda<MockSCMHead, MockSCMRevision>(){

                            @NonNull
                            public MockSCMRevision create(@NonNull MockSCMHead head) throws IOException, InterruptedException {
                                MockSCMSource.this.controller().applyLatency();
                                MockSCMSource.this.controller().checkFaults(MockSCMSource.this.repository, head.getName(), null, false);
                                return new MockSCMRevision(head, MockSCMSource.this.controller().getRevision(MockSCMSource.this.repository, branch));
                            }
                        }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<MockSCMHead, MockSCMRevision>(){

                            @NonNull
                            public SCMSourceCriteria.Probe create(@NonNull MockSCMHead head, @Nullable MockSCMRevision revisionInfo) throws IOException, InterruptedException {
                                MockSCMSource.this.controller().applyLatency();
                                MockSCMSource.this.controller().checkFaults(MockSCMSource.this.repository, head.getName(), revisionInfo.getHash(), false);
                                return new MockSCMProbe(head, revisionInfo.getHash());
                            }
                        }, new SCMSourceRequest.Witness[0])) continue;
                        return;
                    }
                }
                if (request.isFetchTags()) {
                    for (final String tag : this.controller().listTags(this.repository)) {
                        if (!request.process(new MockTagSCMHead(tag, this.controller().getTagTimestamp(this.repository, tag)), (SCMSourceRequest.RevisionLambda)new SCMSourceRequest.RevisionLambda<MockTagSCMHead, MockSCMRevision>(){

                            @NonNull
                            public MockSCMRevision create(@NonNull MockTagSCMHead head) throws IOException, InterruptedException {
                                MockSCMSource.this.controller().applyLatency();
                                MockSCMSource.this.controller().checkFaults(MockSCMSource.this.repository, head.getName(), null, false);
                                return new MockSCMRevision(head, MockSCMSource.this.controller().getRevision(MockSCMSource.this.repository, tag));
                            }
                        }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<MockTagSCMHead, MockSCMRevision>(){

                            @NonNull
                            public SCMSourceCriteria.Probe create(@NonNull MockTagSCMHead head, @Nullable MockSCMRevision revisionInfo) throws IOException, InterruptedException {
                                MockSCMSource.this.controller().applyLatency();
                                MockSCMSource.this.controller().checkFaults(MockSCMSource.this.repository, head.getName(), revisionInfo.getHash(), false);
                                return new MockSCMProbe(head, revisionInfo.getHash());
                            }
                        }, new SCMSourceRequest.Witness[0])) continue;
                        return;
                    }
                }
                if (!request.isFetchChangeRequests()) break block12;
                for (final Integer number : this.controller().listChangeRequests(this.repository)) {
                    this.checkInterrupt();
                    String target = this.controller().getTarget(this.repository, number);
                    Set<MockChangeRequestFlags> crFlags = this.controller.getFlags(this.repository, number);
                    Set<ChangeRequestCheckoutStrategy> strategies = request.getCheckoutStrategies();
                    boolean singleStrategy = strategies.size() == 1;
                    for (ChangeRequestCheckoutStrategy strategy : strategies) {
                        if (!request.process(new MockChangeRequestSCMHead((SCMHeadOrigin)(crFlags.contains((Object)MockChangeRequestFlags.FORK) ? new SCMHeadOrigin.Fork("fork") : null), number, target, strategy, singleStrategy), (SCMSourceRequest.RevisionLambda)new SCMSourceRequest.RevisionLambda<MockChangeRequestSCMHead, MockChangeRequestSCMRevision>(){

                            @NonNull
                            public MockChangeRequestSCMRevision create(@NonNull MockChangeRequestSCMHead head) throws IOException, InterruptedException {
                                MockSCMSource.this.controller().applyLatency();
                                MockSCMSource.this.controller().checkFaults(MockSCMSource.this.repository, head.getName(), null, false);
                                String revision = MockSCMSource.this.controller().getRevision(MockSCMSource.this.repository, "change-request/" + number);
                                String targetRevision = MockSCMSource.this.controller().getRevision(MockSCMSource.this.repository, head.getTarget().getName());
                                return new MockChangeRequestSCMRevision(head, new MockSCMRevision(head.getTarget(), targetRevision), revision);
                            }
                        }, (SCMSourceRequest.ProbeLambda)new SCMSourceRequest.ProbeLambda<MockChangeRequestSCMHead, MockChangeRequestSCMRevision>(){

                            @NonNull
                            public SCMSourceCriteria.Probe create(@NonNull MockChangeRequestSCMHead head, @Nullable MockChangeRequestSCMRevision revisionInfo) throws IOException, InterruptedException {
                                MockSCMSource.this.controller().applyLatency();
                                MockSCMSource.this.controller().checkFaults(MockSCMSource.this.repository, head.getName(), revisionInfo.getHash(), false);
                                return new MockSCMProbe(head, revisionInfo.getHash());
                            }
                        }, new SCMSourceRequest.Witness[0])) continue;
                        return;
                    }
                }
            }
            finally {
                IOUtils.closeQuietly((Closeable)((Object)request));
            }
        }
    }

    @NonNull
    public SCM build(@NonNull SCMHead head, @CheckForNull SCMRevision revision) {
        return ((MockSCMBuilder)new MockSCMBuilder(this, head, revision).withTraits(this.traits)).build();
    }

    @NonNull
    protected List<Action> retrieveActions(@CheckForNull SCMSourceEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.controller().applyLatency();
        this.controller().checkFaults(this.repository, null, null, true);
        ArrayList<Action> result = new ArrayList<Action>();
        result.add(new MockSCMLink("source"));
        String description = this.controller().getDescription(this.repository);
        String displayName = this.controller().getDisplayName(this.repository);
        String url = this.controller().getUrl(this.repository);
        String iconClassName = this.controller().getRepoIconClassName();
        if (description != null || displayName != null || url != null) {
            result.add((Action)new ObjectMetadataAction(displayName, description, url));
        }
        if (iconClassName != null) {
            result.add((Action)new MockAvatarMetadataAction(iconClassName));
        }
        return result;
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMRevision revision, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        String hash;
        this.controller().applyLatency();
        if (revision instanceof MockSCMRevision) {
            hash = ((MockSCMRevision)revision).getHash();
        } else if (revision instanceof MockChangeRequestSCMRevision) {
            hash = ((MockChangeRequestSCMRevision)revision).getHash();
        } else {
            throw new IOException("Unexpected revision");
        }
        this.controller().checkFaults(this.repository, revision.getHead().getName(), hash, true);
        return Collections.singletonList(new MockSCMLink("revision"));
    }

    @NonNull
    protected List<Action> retrieveActions(@NonNull SCMHead head, @CheckForNull SCMHeadEvent event, @NonNull TaskListener listener) throws IOException, InterruptedException {
        this.controller().applyLatency();
        this.controller().checkFaults(this.repository, head.getName(), null, true);
        ArrayList<Action> result = new ArrayList<Action>();
        if (head instanceof MockChangeRequestSCMHead) {
            result.add((Action)new ContributorMetadataAction("bob", "Bob Smith", "bob@example.com"));
            result.add((Action)new ObjectMetadataAction(String.format("Change request #%d", ((MockChangeRequestSCMHead)head).getNumber()), null, "http://changes.example.com/" + ((MockChangeRequestSCMHead)head).getId()));
        }
        result.add(new MockSCMLink("branch"));
        return result;
    }

    protected boolean isCategoryEnabled(@NonNull SCMHeadCategory category) {
        for (SCMSourceTrait trait : this.traits) {
            if (!trait.isCategoryEnabled(category)) continue;
            return true;
        }
        return false;
    }

    private class MockSCMProbe
    extends SCMProbe {
        private final String revision;
        private final SCMHead head;

        public MockSCMProbe(SCMHead head, String revision) {
            this.revision = revision;
            this.head = head;
        }

        @NonNull
        public SCMProbeStat stat(@NonNull String path) throws IOException {
            return SCMProbeStat.fromType((SCMFile.Type)MockSCMSource.this.controller().stat(MockSCMSource.this.repository, this.revision, path));
        }

        public void close() throws IOException {
        }

        public String name() {
            return this.head.getName();
        }

        public long lastModified() {
            return MockSCMSource.this.controller().lastModified(MockSCMSource.this.repository, this.revision);
        }
    }

    @Symbol(value={"mockScm"})
    @Extension
    public static class DescriptorImpl
    extends SCMSourceDescriptor {
        @Nonnull
        public String getDisplayName() {
            return "Mock SCM";
        }

        public ListBoxModel doFillControllerIdItems() {
            ListBoxModel result = new ListBoxModel();
            for (MockSCMController c : MockSCMController.all()) {
                result.add(c.getId());
            }
            return result;
        }

        public ListBoxModel doFillRepositoryItems(@QueryParameter String controllerId) throws IOException {
            ListBoxModel result = new ListBoxModel();
            MockSCMController c = MockSCMController.lookup(controllerId);
            if (c != null) {
                for (String r : c.listRepositories()) {
                    result.add(r);
                }
            }
            return result;
        }

        @NonNull
        protected SCMHeadCategory[] createCategories() {
            return new SCMHeadCategory[]{UncategorizedSCMHeadCategory.DEFAULT, ChangeRequestSCMHeadCategory.DEFAULT, TagSCMHeadCategory.DEFAULT};
        }

        public List<SCMSourceTraitDescriptor> getTraitsDescriptors() {
            return SCMSourceTrait._for((SCMSourceDescriptor)this, MockSCMSourceContext.class, MockSCMBuilder.class);
        }

        public List<SCMSourceTrait> getTraitsDefaults() {
            return Collections.singletonList(new MockSCMDiscoverBranches());
        }
    }
}

