/*
 * Decompiled with CFR 0.152.
 */
package jenkins.scm.api;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.ExtensionList;
import hudson.init.Terminator;
import hudson.model.Cause;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.util.ClassLoaderSanityThreadFactory;
import hudson.util.DaemonThreadFactory;
import hudson.util.NamingThreadFactory;
import io.jenkins.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import jenkins.scm.api.SCMEventListener;
import jenkins.security.ImpersonatingScheduledExecutorService;
import jenkins.util.SystemProperties;
import org.apache.commons.lang3.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.Stapler;
import org.springframework.security.core.Authentication;

public abstract class SCMEvent<P> {
    private static final Cause[] EMPTY_CAUSES = new Cause[0];
    public static final String ORIGIN_UNKNOWN = "?";
    private static final int EVENT_THREAD_POOL_SIZE = SystemProperties.getInteger((String)(SCMEvent.class.getName() + ".EVENT_THREAD_POOL_SIZE"), (Integer)10);
    @NonNull
    private final Type type;
    private final long timestamp;
    @NonNull
    private final P payload;
    @CheckForNull
    private final String origin;
    private static ScheduledExecutorService executorService;
    private static ScheduledThreadPoolExecutor threadPoolExecutor;

    @Deprecated
    public SCMEvent(@NonNull Type type, long timestamp, @NonNull P payload) {
        this(type, timestamp, payload, SCMEvent.originOf((HttpServletRequest)Stapler.getCurrentRequest2()));
    }

    public SCMEvent(@NonNull Type type, long timestamp, @NonNull P payload, @CheckForNull String origin) {
        this.type = type;
        this.timestamp = timestamp;
        this.payload = payload;
        this.origin = ORIGIN_UNKNOWN.equals(origin) ? null : origin;
    }

    @Deprecated
    public SCMEvent(@NonNull Type type, @NonNull P payload) {
        this(type, System.currentTimeMillis(), payload);
    }

    public SCMEvent(@NonNull Type type, @NonNull P payload, @CheckForNull String origin) {
        this(type, System.currentTimeMillis(), payload, origin);
    }

    protected SCMEvent(SCMEvent<P> copy) {
        this(copy.getType(), copy.getTimestamp(), copy.getPayload(), copy.origin);
    }

    @NonNull
    protected static synchronized ScheduledExecutorService executorService() {
        if (executorService == null) {
            threadPoolExecutor = new ScheduledThreadPoolExecutor(EVENT_THREAD_POOL_SIZE, (ThreadFactory)new NamingThreadFactory((ThreadFactory)new ClassLoaderSanityThreadFactory((ThreadFactory)new DaemonThreadFactory()), "SCMEvent"));
            executorService = new ImpersonatingScheduledExecutorService((ScheduledExecutorService)threadPoolExecutor, ACL.SYSTEM2);
        }
        return executorService;
    }

    public static EventQueueMetrics getEventProcessingMetrics() {
        return new EventQueueMetrics(threadPoolExecutor);
    }

    @Terminator
    public static synchronized void closeExecutorService() {
        if (executorService != null) {
            executorService.shutdownNow();
            executorService = null;
        }
    }

    @NonNull
    public Type getType() {
        return this.type;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    @NonNull
    public Date getDate() {
        return new Date(this.timestamp);
    }

    @NonNull
    public P getPayload() {
        return this.payload;
    }

    @NonNull
    public String getOrigin() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.origin, (CharSequence)ORIGIN_UNKNOWN);
    }

    @CheckForNull
    public String description() {
        return null;
    }

    @NonNull
    public Cause[] asCauses() {
        return EMPTY_CAUSES;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SCMEvent scmEvent = (SCMEvent)o;
        if (this.type != scmEvent.type) {
            return false;
        }
        if (this.timestamp != scmEvent.timestamp) {
            return false;
        }
        return this.payload.equals(scmEvent.payload);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.payload.hashCode();
        return result;
    }

    public String toString() {
        return String.format("SCMEvent{type=%s, timestamp=%tc, payload=%s, origin=%s}", new Object[]{this.type, this.timestamp, this.payload, StringUtils.defaultIfBlank((CharSequence)this.origin, (CharSequence)ORIGIN_UNKNOWN)});
    }

    @CheckForNull
    public static String originOf(@CheckForNull HttpServletRequest req) {
        int port;
        if (req == null) {
            return null;
        }
        String last = null;
        StringBuilder result = new StringBuilder();
        String header = req.getHeader("X-Forwarded-For");
        if (StringUtils.isNotBlank((CharSequence)header)) {
            for (String remote : header.split("(,\\s*)")) {
                if (StringUtils.isBlank((CharSequence)remote)) continue;
                if (last != null) {
                    result.append(" \u2192 ");
                }
                last = StringUtils.trim((String)remote);
                result.append(last);
            }
        }
        String remoteHost = req.getRemoteHost();
        String remoteAddr = req.getRemoteAddr();
        if (last == null || !StringUtils.equals(last, (CharSequence)remoteHost) && !StringUtils.equals(last, (CharSequence)remoteAddr)) {
            if (last != null) {
                result.append(" \u2192 ");
            }
            if (!StringUtils.isBlank((CharSequence)remoteHost) && !remoteHost.equals(remoteAddr)) {
                result.append(remoteHost);
                result.append('/');
            }
            result.append(remoteAddr);
        }
        result.append(" \u21d2 ");
        String scheme = (String)StringUtils.defaultIfBlank((CharSequence)req.getHeader("X-Forwarded-Proto"), (CharSequence)req.getScheme());
        result.append(scheme);
        result.append("://");
        result.append(req.getServerName());
        String portStr = req.getHeader("X-Forwarded-Port");
        if (portStr != null) {
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                port = req.getLocalPort();
            }
        } else {
            port = req.getLocalPort();
        }
        if (!("http".equals(scheme) && port == 80 || "https".equals(scheme) && port == 443)) {
            result.append(':');
            result.append(port);
        }
        result.append(req.getRequestURI());
        return result.toString();
    }

    @Deprecated
    @CheckForNull
    public static String originOf(@CheckForNull javax.servlet.http.HttpServletRequest req) {
        return req != null ? SCMEvent.originOf(HttpServletRequestWrapper.toJakartaHttpServletRequest((javax.servlet.http.HttpServletRequest)req)) : null;
    }

    public static enum Type {
        CREATED,
        UPDATED,
        REMOVED;

    }

    public static class EventQueueMetrics {
        private final ThreadPoolExecutor executor;

        public EventQueueMetrics(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        public int getPoolSize() {
            return this.executor == null ? 0 : this.executor.getPoolSize();
        }

        public int getActiveThreads() {
            return this.executor == null ? 0 : this.executor.getActiveCount();
        }

        public int getQueuedTasks() {
            return this.executor == null ? 0 : this.executor.getQueue().size();
        }

        public long getCompletedTasks() {
            return this.executor == null ? 0L : this.executor.getCompletedTaskCount();
        }
    }

    protected static abstract class Dispatcher<E extends SCMEvent<?>>
    implements Runnable {
        @Restricted(value={NoExternalUse.class})
        static final AtomicLong lastId = new AtomicLong();
        @Restricted(value={NoExternalUse.class})
        static final Lock lock = new ReentrantLock();
        @Restricted(value={NoExternalUse.class})
        static final Condition started = lock.newCondition();
        @Restricted(value={NoExternalUse.class})
        static final Condition finished = lock.newCondition();
        @Restricted(value={NoExternalUse.class})
        static long startedId = 0L;
        @Restricted(value={NoExternalUse.class})
        static long finishedId = 0L;
        @Restricted(value={NoExternalUse.class})
        static int inFlight = 0;
        private final long id;
        private final E event;

        public Dispatcher(E event) {
            this.event = event;
            this.id = lastId.incrementAndGet();
        }

        protected abstract void log(SCMEventListener var1, Throwable var2);

        protected abstract void fire(SCMEventListener var1, E var2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            lock.lock();
            try {
                if (startedId < this.id) {
                    startedId = this.id;
                    started.signalAll();
                }
                ++inFlight;
            }
            finally {
                lock.unlock();
            }
            String oldName = Thread.currentThread().getName();
            try {
                Thread.currentThread().setName(String.format("%s %tc / %s", this.event.getClass(), ((SCMEvent)this.event).getTimestamp(), oldName));
                for (SCMEventListener l : ExtensionList.lookup(SCMEventListener.class)) {
                    ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);
                    try {
                        try {
                            this.fire(l, this.event);
                        }
                        catch (LinkageError e) {
                            this.log(l, e);
                        }
                        catch (Error e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            this.log(l, e);
                        }
                    }
                    finally {
                        if (ctx == null) continue;
                        ctx.close();
                    }
                }
            }
            finally {
                Thread.currentThread().setName(oldName);
                lock.lock();
                try {
                    if (finishedId < this.id) {
                        finishedId = this.id;
                    }
                    if (--inFlight <= 0) {
                        inFlight = 0;
                        finished.signalAll();
                    }
                }
                finally {
                    lock.unlock();
                }
            }
        }
    }
}

