/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.scriptsecurity.sandbox.groovy;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import java.beans.Introspector;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.GroovySandbox;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SandboxResolvingClassLoader;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.jenkinsci.plugins.scriptsecurity.scripts.ClasspathEntry;
import org.jenkinsci.plugins.scriptsecurity.scripts.ScriptApproval;
import org.jenkinsci.plugins.scriptsecurity.scripts.languages.GroovyLanguage;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public final class SecureGroovyScript
extends AbstractDescribableImpl<SecureGroovyScript>
implements Serializable {
    private static final long serialVersionUID = -4347442065624787928L;
    @NonNull
    private final String script;
    private final boolean sandbox;
    @CheckForNull
    private final List<ClasspathEntry> classpath;
    private transient String oldScript;
    private transient boolean calledConfiguring;
    static final Logger LOGGER = Logger.getLogger(SecureGroovyScript.class.getName());

    @DataBoundConstructor
    public SecureGroovyScript(@NonNull String script, boolean sandbox, @CheckForNull List<ClasspathEntry> classpath) throws Descriptor.FormException {
        ScriptApproval.validateSandbox(sandbox);
        this.script = script;
        this.sandbox = sandbox;
        this.classpath = classpath;
    }

    @Deprecated
    public SecureGroovyScript(@NonNull String script, boolean sandbox) throws Descriptor.FormException {
        this(script, sandbox, null);
    }

    private Object readResolve() {
        this.configuring(ApprovalContext.create());
        return this;
    }

    @NonNull
    public String getScript() {
        return this.script;
    }

    public boolean isSandbox() {
        return this.sandbox;
    }

    @NonNull
    public List<ClasspathEntry> getClasspath() {
        return this.classpath != null ? this.classpath : Collections.emptyList();
    }

    public String getOldScript() {
        return this.oldScript;
    }

    @DataBoundSetter
    public void setOldScript(String oldScript) {
        this.oldScript = oldScript;
    }

    @Restricted(value={NoExternalUse.class})
    public boolean isScriptAutoApprovalEnabled() {
        return ScriptApproval.ADMIN_AUTO_APPROVAL_ENABLED;
    }

    public SecureGroovyScript configuring(ApprovalContext context) {
        this.calledConfiguring = true;
        if (!this.sandbox) {
            ScriptApproval.get().configuring(this.script, GroovyLanguage.get(), context, !Objects.equals(this.oldScript, this.script));
        }
        for (ClasspathEntry entry : this.getClasspath()) {
            ScriptApproval.get().configuring(entry, context);
        }
        return this;
    }

    @CheckForNull
    private static Item currentItem() {
        StaplerRequest2 req = Stapler.getCurrentRequest2();
        return req != null ? (Item)req.findAncestorObject(Item.class) : null;
    }

    public SecureGroovyScript configuringWithKeyItem() {
        ApprovalContext context = ApprovalContext.create();
        context = context.withCurrentUser().withItemAsKey(SecureGroovyScript.currentItem());
        return this.configuring(context);
    }

    public SecureGroovyScript configuringWithNonKeyItem() {
        ApprovalContext context = ApprovalContext.create();
        context = context.withCurrentUser().withItem(SecureGroovyScript.currentItem());
        return this.configuring(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpLoader(ClassLoader loader, Set<ClassLoader> encounteredLoaders, Set<Class<?>> encounteredClasses) throws Exception {
        if (!encounteredLoaders.add(loader)) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "found {0}", String.valueOf(loader));
        }
        if (loader instanceof GroovyClassLoader) {
            GroovyClassLoader gcl = (GroovyClassLoader)loader;
            for (Class clazz : gcl.getLoadedClasses()) {
                SecureGroovyScript.cleanUpClass(clazz, encounteredLoaders, encounteredClasses);
            }
            gcl.clearCache();
        } else if (!(loader instanceof SandboxResolvingClassLoader)) {
            if (loader instanceof ClasspathURLClassLoader) {
                Collection<Class<?>> loadedClasses = ((ClasspathURLClassLoader)loader).loadedClasses;
                Collection<Class<?>> collection = loadedClasses;
                synchronized (collection) {
                    loadedClasses = new ArrayList(loadedClasses);
                }
                for (Class clazz : loadedClasses) {
                    SecureGroovyScript.cleanUpClass(clazz, encounteredLoaders, encounteredClasses);
                }
            } else {
                LOGGER.log(Level.FINER, "ignoring {0}", loader);
                return;
            }
        }
        SecureGroovyScript.cleanUpGlobalClassValue(loader);
        SecureGroovyScript.cleanUpLoader(loader.getParent(), encounteredLoaders, encounteredClasses);
    }

    private static void cleanUpClass(Class<?> clazz, Set<ClassLoader> encounteredLoaders, Set<Class<?>> encounteredClasses) throws Exception {
        if (encounteredClasses.add(clazz)) {
            LOGGER.log(Level.FINER, "found {0}", clazz.getName());
            Introspector.flushFromCaches(clazz);
            SecureGroovyScript.cleanUpGlobalClassSet(clazz);
            SecureGroovyScript.cleanUpClassHelperCache(clazz);
            SecureGroovyScript.cleanUpLoader(clazz.getClassLoader(), encounteredLoaders, encounteredClasses);
        }
    }

    private static void cleanUpGlobalClassValue(@NonNull ClassLoader loader) throws Exception {
        Class<?> classInfoC = Class.forName("org.codehaus.groovy.reflection.ClassInfo");
        Field globalClassValueF = classInfoC.getDeclaredField("globalClassValue");
        globalClassValueF.setAccessible(true);
        Object globalClassValue = globalClassValueF.get(null);
        Class<?> groovyClassValuePreJava7C = Class.forName("org.codehaus.groovy.reflection.GroovyClassValuePreJava7");
        if (!groovyClassValuePreJava7C.isInstance(globalClassValue)) {
            return;
        }
        Field mapF = groovyClassValuePreJava7C.getDeclaredField("map");
        mapF.setAccessible(true);
        Object map = mapF.get(globalClassValue);
        Class<?> groovyClassValuePreJava7Map = Class.forName("org.codehaus.groovy.reflection.GroovyClassValuePreJava7$GroovyClassValuePreJava7Map");
        Collection entries = (Collection)groovyClassValuePreJava7Map.getMethod("values", new Class[0]).invoke(map, new Object[0]);
        Method removeM = groovyClassValuePreJava7Map.getMethod("remove", Object.class);
        Class<?> entryC = Class.forName("org.codehaus.groovy.util.AbstractConcurrentMapBase$Entry");
        Method getValueM = entryC.getMethod("getValue", new Class[0]);
        ArrayList<Class> toRemove = new ArrayList<Class>();
        try {
            Field classRefF = classInfoC.getDeclaredField("classRef");
            classRefF.setAccessible(true);
            for (Iterator entry : entries) {
                Object value = getValueM.invoke(entry, new Object[0]);
                toRemove.add((Class)((WeakReference)classRefF.get(value)).get());
            }
        }
        catch (NoSuchFieldException x) {
            Field klazzF = classInfoC.getDeclaredField("klazz");
            klazzF.setAccessible(true);
            for (Object entry : entries) {
                Object value = getValueM.invoke(entry, new Object[0]);
                toRemove.add((Class)klazzF.get(value));
            }
        }
        Iterator it = toRemove.iterator();
        while (it.hasNext()) {
            Class klazz = (Class)it.next();
            ClassLoader encounteredLoader = klazz.getClassLoader();
            if (encounteredLoader == loader) continue;
            it.remove();
            if (!LOGGER.isLoggable(Level.FINEST)) continue;
            LOGGER.log(Level.FINEST, "ignoring {0} with loader {1}", new Object[]{klazz, String.valueOf(encounteredLoader)});
        }
        LOGGER.log(Level.FINE, "cleaning up {0} associated with {1}", new Object[]{((Object)toRemove).toString(), loader.toString()});
        for (Class klazz : toRemove) {
            removeM.invoke(map, klazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cleanUpGlobalClassSet(@NonNull Class<?> clazz) throws Exception {
        Class<?> classInfoC = Class.forName("org.codehaus.groovy.reflection.ClassInfo");
        Field globalClassSetF = classInfoC.getDeclaredField("globalClassSet");
        globalClassSetF.setAccessible(true);
        Object globalClassSet = globalClassSetF.get(null);
        try {
            classInfoC.getDeclaredField("classRef");
            return;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Field itemsF = globalClassSet.getClass().getDeclaredField("items");
            itemsF.setAccessible(true);
            Object items = itemsF.get(globalClassSet);
            Method iteratorM = items.getClass().getMethod("iterator", new Class[0]);
            Field klazzF = classInfoC.getDeclaredField("klazz");
            klazzF.setAccessible(true);
            Object object = items;
            synchronized (object) {
                Iterator iterator = (Iterator)iteratorM.invoke(items, new Object[0]);
                while (iterator.hasNext()) {
                    Object classInfo = iterator.next();
                    if (classInfo == null) {
                        LOGGER.finer("JENKINS-41945: ignoring null ClassInfo from ManagedLinkedList.Iter.next");
                        continue;
                    }
                    if (klazzF.get(classInfo) != clazz) continue;
                    iterator.remove();
                    LOGGER.log(Level.FINER, "cleaning up {0} from GlobalClassSet", clazz.getName());
                }
            }
            return;
        }
    }

    private static void cleanUpClassHelperCache(@NonNull Class<?> clazz) throws Exception {
        Field classCacheF = Class.forName("org.codehaus.groovy.ast.ClassHelper$ClassHelperCache").getDeclaredField("classCache");
        classCacheF.setAccessible(true);
        Object classCache = classCacheF.get(null);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.log(Level.FINER, "cleaning up {0} from ClassHelperCache? {1}", new Object[]{clazz.getName(), classCache.getClass().getMethod("get", Object.class).invoke(classCache, clazz) != null});
        }
        classCache.getClass().getMethod("remove", Object.class).invoke(classCache, clazz);
    }

    @Deprecated
    public Object evaluate(ClassLoader loader, Binding binding) throws Exception {
        return this.evaluate(loader, binding, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(ClassLoader loader, Binding binding, @CheckForNull TaskListener listener) throws Exception {
        GroovyShell sh;
        Field loaderF;
        boolean canDoCleanup;
        CleanGroovyClassLoader memoryProtectedLoader;
        URLClassLoader urlcl;
        block22: {
            Object object;
            if (!this.calledConfiguring) {
                throw new IllegalStateException("you need to call configuring or a related method before using GroovyScript");
            }
            urlcl = null;
            memoryProtectedLoader = null;
            List<ClasspathEntry> cp = this.getClasspath();
            if (!cp.isEmpty()) {
                ArrayList<URL> urlList = new ArrayList<URL>(cp.size());
                for (ClasspathEntry entry : cp) {
                    ScriptApproval.get().using(entry);
                    urlList.add(entry.getURL());
                }
                urlcl = new ClasspathURLClassLoader(urlList.toArray(new URL[urlList.size()]), loader);
                loader = urlcl;
            }
            canDoCleanup = false;
            try {
                loader = GroovySandbox.createSecureClassLoader(loader);
                loaderF = null;
                try {
                    loaderF = GroovyShell.class.getDeclaredField("loader");
                    loaderF.setAccessible(true);
                    canDoCleanup = true;
                }
                catch (NoSuchFieldException nsme) {
                    LOGGER.log(Level.FINE, "GroovyShell fields have changed, field loader no longer exists -- memory leak fixes won't work");
                }
                if (!this.sandbox) break block22;
                CompilerConfiguration cc = GroovySandbox.createSecureCompilerConfiguration();
                sh = new GroovyShell(loader, binding, cc);
                if (canDoCleanup) {
                    memoryProtectedLoader = new CleanGroovyClassLoader(loader, cc);
                    loaderF.set(sh, (Object)memoryProtectedLoader);
                }
                object = new GroovySandbox().withTaskListener(listener).runScript(sh, this.script);
            }
            catch (Throwable throwable) {
                try {
                    if (canDoCleanup) {
                        SecureGroovyScript.cleanUpLoader(memoryProtectedLoader, new HashSet<ClassLoader>(), new HashSet());
                    }
                }
                catch (Exception x) {
                    LOGGER.log(Level.WARNING, "failed to clean up memory ", x);
                }
                if (urlcl != null) {
                    urlcl.close();
                }
                throw throwable;
            }
            try {
                if (canDoCleanup) {
                    SecureGroovyScript.cleanUpLoader((ClassLoader)((Object)memoryProtectedLoader), new HashSet<ClassLoader>(), new HashSet());
                }
            }
            catch (Exception x) {
                LOGGER.log(Level.WARNING, "failed to clean up memory ", x);
            }
            if (urlcl != null) {
                urlcl.close();
            }
            return object;
        }
        sh = new GroovyShell(loader, binding);
        if (canDoCleanup) {
            memoryProtectedLoader = new CleanGroovyClassLoader(loader);
            loaderF.set(sh, (Object)memoryProtectedLoader);
        }
        Object object = sh.evaluate(ScriptApproval.get().using(this.script, GroovyLanguage.get()));
        try {
            if (canDoCleanup) {
                SecureGroovyScript.cleanUpLoader((ClassLoader)((Object)memoryProtectedLoader), new HashSet<ClassLoader>(), new HashSet());
            }
        }
        catch (Exception x) {
            LOGGER.log(Level.WARNING, "failed to clean up memory ", x);
        }
        if (urlcl != null) {
            urlcl.close();
        }
        return object;
    }

    private static final class ClasspathURLClassLoader
    extends URLClassLoader {
        private final Collection<Class<?>> loadedClasses = new ArrayList();

        ClasspathURLClassLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> c = super.findClass(name);
            Collection<Class<?>> collection = this.loadedClasses;
            synchronized (collection) {
                this.loadedClasses.add(c);
            }
            return c;
        }
    }

    static final class CleanGroovyClassLoader
    extends GroovyClassLoader {
        CleanGroovyClassLoader(ClassLoader loader, CompilerConfiguration config) {
            super(loader, config);
        }

        CleanGroovyClassLoader(ClassLoader loader) {
            super(loader);
        }

        protected GroovyClassLoader.ClassCollector createCollector(CompilationUnit unit, SourceUnit su) {
            return new CleanClassCollector(unit, su);
        }

        private final class CleanClassCollector
        extends GroovyClassLoader.ClassCollector {
            CleanClassCollector(CompilationUnit unit, SourceUnit su) {
                super(null, unit, su);
            }

            public GroovyClassLoader getDefiningClassLoader() {
                return CleanGroovyClassLoader.this;
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SecureGroovyScript> {
        @NonNull
        public String getDisplayName() {
            return "";
        }

        @RequirePOST
        public FormValidation doCheckScript(@QueryParameter String value, @QueryParameter boolean sandbox, @QueryParameter String oldScript) {
            FormValidation validationResult = GroovySandbox.checkScriptForCompilationErrors(value, new GroovyClassLoader(Jenkins.get().getPluginManager().uberClassLoader));
            if (validationResult.kind != FormValidation.Kind.OK) {
                return validationResult;
            }
            return sandbox ? FormValidation.ok() : ScriptApproval.get().checking(value, GroovyLanguage.get(), !Objects.equals(oldScript, value));
        }

        @Restricted(value={NoExternalUse.class})
        public boolean shouldHideSandbox(@CheckForNull SecureGroovyScript instance) {
            return ScriptApproval.shouldHideSandbox(instance, SecureGroovyScript::isSandbox);
        }
    }
}

