/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.stashNotifier;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import hudson.Extension;
import hudson.ExtensionList;
import jakarta.inject.Named;
import jakarta.inject.Singleton;
import java.util.List;
import org.jenkinsci.plugins.stashNotifier.DefaultApacheHttpNotifier;
import org.jenkinsci.plugins.stashNotifier.DefaultHttpNotifierSelector;
import org.jenkinsci.plugins.stashNotifier.HttpNotifier;
import org.jenkinsci.plugins.stashNotifier.HttpNotifierSelector;
import org.jenkinsci.plugins.stashNotifier.StashNotifierDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class StashNotifierModule
extends AbstractModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(StashNotifierModule.class);

    protected void configure() {
    }

    @Provides
    @Singleton
    @StashNotifierDefault
    HttpNotifier providesDefaultHttpNotifier() {
        return new DefaultApacheHttpNotifier();
    }

    @Provides
    @Singleton
    @StashNotifierDefault
    HttpNotifierSelector providesDefaultApacheHttpNotifierSelector(@StashNotifierDefault HttpNotifier httpNotifier) {
        return new DefaultHttpNotifierSelector(httpNotifier);
    }

    @Provides
    List<HttpNotifierSelector> providesHttpNotifierSelectors() {
        return ExtensionList.lookup(HttpNotifierSelector.class);
    }

    @Provides
    @Singleton
    HttpNotifierSelector providesHttpNotifierSelector(@StashNotifierDefault HttpNotifierSelector fallback, @Named(value="preferredHttpNotifierSelector") String preferredHttpNotifierSelector, List<HttpNotifierSelector> httpNotifierSelectors) {
        HttpNotifierSelector selector = httpNotifierSelectors.stream().filter(s -> s.getClass().getName().equals(preferredHttpNotifierSelector)).findFirst().orElse(fallback);
        Class<?> selectedClass = selector.getClass();
        if (selectedClass.getName().equals(preferredHttpNotifierSelector)) {
            LOGGER.debug("Using {}", (Object)selectedClass.getName());
        } else {
            LOGGER.warn("{} not found - using {}", (Object)preferredHttpNotifierSelector, (Object)selectedClass.getName());
        }
        return selector;
    }

    @Provides
    @Singleton
    @Named(value="preferredHttpNotifierSelector")
    String providesPreferredHttpNotifierSelector() {
        String override = HttpNotifierSelector.class.getName() + ".className";
        return System.getProperty(override, DefaultHttpNotifierSelector.class.getName());
    }
}

