/*
 * Decompiled with CFR 0.152.
 */
package hudson.scm;

import com.thoughtworks.xstream.XStream;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.XmlFile;
import hudson.model.Job;
import hudson.scm.SubversionSCM;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

class SvnExternalsFileManager {
    private static final String SVN_EXTERNALS_FILE = "svnexternals.txt";
    private static final XStream XSTREAM = new XStream2();
    private static Map<Job, Object> projectExternalsCache;

    SvnExternalsFileManager() {
    }

    @NonNull
    private static synchronized Object getFileLockItem(Job project) {
        Object item;
        if (projectExternalsCache == null) {
            projectExternalsCache = new WeakHashMap<Job, Object>();
        }
        if ((item = projectExternalsCache.get(project)) == null) {
            item = new Object();
            projectExternalsCache.put(project, item);
        }
        return item;
    }

    @NonNull
    private static File getExternalsFile(Job project) {
        return new File(project.getRootDir(), SVN_EXTERNALS_FILE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static List<SubversionSCM.External> parseExternalsFile(Job project) throws IOException {
        Object lock;
        File file = SvnExternalsFileManager.getExternalsFile(project);
        Object object = lock = SvnExternalsFileManager.getFileLockItem(project);
        synchronized (object) {
            if (file.exists()) {
                try {
                    return (List)new XmlFile(XSTREAM, file).read();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeExternalsFile(Job project, List<SubversionSCM.External> externals) throws IOException {
        Object lock;
        Object object = lock = SvnExternalsFileManager.getFileLockItem(project);
        synchronized (object) {
            new XmlFile(XSTREAM, SvnExternalsFileManager.getExternalsFile(project)).write(externals);
        }
    }

    static {
        XSTREAM.alias("external", SubversionSCM.External.class);
    }
}

