/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.tokenmacro.impl;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jenkinsci.plugins.tokenmacro.DataBoundTokenMacro;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

@Extension
public class WorkspaceFileMacro
extends DataBoundTokenMacro {
    @DataBoundTokenMacro.Parameter(required=true)
    public String path = "";
    @DataBoundTokenMacro.Parameter
    public String fileNotFoundMessage = "ERROR: File '%s' does not exist";
    @DataBoundTokenMacro.Parameter
    public int maxLines = -1;
    @DataBoundTokenMacro.Parameter
    public String charSet = Charset.defaultCharset().name();
    public static final String MACRO_NAME = "FILE";

    @Override
    public boolean acceptsMacroName(String macroName) {
        return macroName.equals(MACRO_NAME);
    }

    @Override
    public List<String> getAcceptedMacroNames() {
        return Collections.singletonList(MACRO_NAME);
    }

    @Override
    public String evaluate(AbstractBuild<?, ?> context, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        return this.evaluate((Run<?, ?>)context, WorkspaceFileMacro.getWorkspace(context), listener, macroName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String evaluate(Run<?, ?> run, FilePath workspace, TaskListener listener, String macroName) throws MacroEvaluationException, IOException, InterruptedException {
        try {
            EnvVars env = run.getEnvironment(listener);
            this.path = env.expand(this.path);
        }
        catch (Exception e) {
            listener.error("Error retrieving environment: %s", new Object[]{e.getMessage()});
        }
        if (!workspace.child(this.path).exists()) {
            return String.format(this.fileNotFoundMessage, this.path);
        }
        try {
            Charset charset = Charset.forName(this.charSet);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(workspace.child(this.path).read(), charset));){
                if (this.maxLines > 0) {
                    String string = reader.lines().limit(this.maxLines).collect(Collectors.joining("\n"));
                    return string;
                }
                String string = reader.lines().collect(Collectors.joining("\n"));
                return string;
            }
        }
        catch (IOException e) {
            return "ERROR: File '" + this.path + "' could not be read";
        }
    }

    @Override
    public boolean hasNestedContent() {
        return true;
    }
}

