/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.kubernetes.credentials;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.UsernamePasswordCredentialsImpl;
import hudson.Extension;
import hudson.util.Secret;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.HostnameVerifier;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolException;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.jenkinsci.plugins.kubernetes.credentials.TokenProducer;
import org.kohsuke.stapler.DataBoundConstructor;

public class OpenShiftBearerTokenCredentialImpl
extends UsernamePasswordCredentialsImpl
implements TokenProducer {
    private static final long serialVersionUID = 6031616605797622926L;
    private transient AtomicReference<Token> token = new AtomicReference();
    private static TrustStrategy ALWAYS = new TrustStrategy(){

        public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            return true;
        }
    };
    private static RedirectStrategy NO_REDIRECT = new RedirectStrategy(){

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return false;
        }

        public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            return null;
        }
    };

    @DataBoundConstructor
    public OpenShiftBearerTokenCredentialImpl(CredentialsScope scope, String id, String description, String username, String password) {
        super(scope, id, description, username, password);
    }

    private Object readResolve() {
        this.token = new AtomicReference();
        return this;
    }

    @Override
    public String getToken(String serviceAddress, String caCertData, boolean skipTlsVerify) throws IOException {
        Token t = this.token.get();
        if (t == null || System.currentTimeMillis() > t.expire) {
            t = this.refreshToken(serviceAddress, caCertData, skipTlsVerify);
        }
        return t.value;
    }

    private synchronized Token refreshToken(String serviceAddress, String caCertData, boolean skipTlsVerify) throws IOException {
        URI uri = null;
        try {
            uri = new URI(serviceAddress);
        }
        catch (URISyntaxException e) {
            throw new IOException("Invalid server URL " + serviceAddress, e);
        }
        HttpClientBuilder builder = HttpClients.custom().setRedirectStrategy(NO_REDIRECT);
        if (skipTlsVerify || caCertData != null) {
            SSLContextBuilder sslBuilder = new SSLContextBuilder();
            HostnameVerifier hostnameVerifier = SSLConnectionSocketFactory.getDefaultHostnameVerifier();
            try {
                if (skipTlsVerify) {
                    sslBuilder.loadTrustMaterial(null, ALWAYS);
                    hostnameVerifier = NoopHostnameVerifier.INSTANCE;
                } else if (caCertData != null) {
                    KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                    ks.load(null);
                    CertificateFactory f = CertificateFactory.getInstance("X509");
                    X509Certificate cert = (X509Certificate)f.generateCertificate((InputStream)new Base64InputStream((InputStream)new ByteArrayInputStream(caCertData.getBytes(StandardCharsets.UTF_8))));
                    ks.setCertificateEntry(uri.getHost(), cert);
                    sslBuilder.loadTrustMaterial(ks, null);
                }
                builder.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslBuilder.build(), hostnameVerifier));
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
            catch (KeyManagementException e) {
                e.printStackTrace();
            }
            catch (KeyStoreException e) {
                e.printStackTrace();
            }
            catch (CertificateException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        HttpGet authorize = new HttpGet(serviceAddress + "/oauth/authorize?client_id=openshift-challenging-client&response_type=token");
        authorize.setHeader("Authorization", "Basic " + Base64.encodeBase64String((byte[])(this.getUsername() + ':' + Secret.toString((Secret)this.getPassword())).getBytes(StandardCharsets.UTF_8)));
        CloseableHttpResponse response = builder.build().execute((HttpUriRequest)authorize);
        if (response.getStatusLine().getStatusCode() != 302) {
            throw new IOException("Failed to get an OAuth access token " + response.getStatusLine().getStatusCode());
        }
        String location = response.getFirstHeader("Location").getValue();
        String parameters = location.substring(location.indexOf(35) + 1);
        List pairs = URLEncodedUtils.parse((String)parameters, (Charset)StandardCharsets.UTF_8);
        Token t = new Token();
        for (NameValuePair pair : pairs) {
            if (pair.getName().equals("access_token")) {
                t.value = pair.getValue();
                continue;
            }
            if (!pair.getName().equals("expires_in")) continue;
            t.expire = System.currentTimeMillis() + Long.parseLong(pair.getValue()) * 1000L - 100L;
        }
        return t;
    }

    private static class Token {
        String value;
        long expire;

        private Token() {
        }
    }

    @Extension
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        public String getDisplayName() {
            return "OpenShift Username and Password";
        }
    }
}

