/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.pipeline.modeldefinition.ast;

import net.sf.json.JSONObject;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTBranch;
import org.jenkinsci.plugins.pipeline.modeldefinition.ast.ModelASTElement;
import org.jenkinsci.plugins.pipeline.modeldefinition.validator.ModelValidator;

public final class ModelASTBuildCondition
extends ModelASTElement {
    private String condition;
    private ModelASTBranch branch;

    public ModelASTBuildCondition(Object sourceLocation) {
        super(sourceLocation);
    }

    public JSONObject toJSON() {
        return new JSONObject().accumulate("condition", (Object)this.condition).accumulate("branch", (Object)this.branch.toJSON());
    }

    @Override
    public void validate(ModelValidator validator) {
        validator.validateElement(this);
        this.branch.validate(validator);
    }

    @Override
    public String toGroovy() {
        return this.condition + " {\n" + this.branch.toGroovy() + "\n}\n";
    }

    @Override
    public void removeSourceLocation() {
        super.removeSourceLocation();
        this.branch.removeSourceLocation();
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public ModelASTBranch getBranch() {
        return this.branch;
    }

    public void setBranch(ModelASTBranch branch) {
        this.branch = branch;
    }

    @Override
    public String toString() {
        return "ModelASTBuildCondition{condition='" + this.condition + '\'' + ", branch=" + this.branch + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ModelASTBuildCondition that = (ModelASTBuildCondition)o;
        if (this.getCondition() != null ? !this.getCondition().equals(that.getCondition()) : that.getCondition() != null) {
            return false;
        }
        return this.getBranch() != null ? this.getBranch().equals(that.getBranch()) : that.getBranch() == null;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.getCondition() != null ? this.getCondition().hashCode() : 0);
        result = 31 * result + (this.getBranch() != null ? this.getBranch().hashCode() : 0);
        return result;
    }
}

